/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.repository.datasource;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.logging.Logger;
import javax.sql.DataSource;
import org.eclipse.dirigible.repository.datasource.WrappedConnection;

public class WrappedDataSource
implements DataSource {
    private static final org.eclipse.dirigible.repository.logging.Logger logger = org.eclipse.dirigible.repository.logging.Logger.getLogger(WrappedDataSource.class);
    private DataSource originalDataSource;
    private static final Collection<WrappedConnection> connections = Collections.synchronizedCollection(new ArrayList());
    private static int MAX_CONNECTIONS_COUNT = 8;
    private static long WAIT_TIMEOUT = 500L;
    private static int WAIT_COUNT = 5;
    private static boolean AUTO_COMMIT_ENABLED = false;

    public WrappedDataSource(DataSource originalDataSource) {
        this.initAutoCommitEnabled();
        this.initMaxConnectionsCount();
        this.initWaitTimeout();
        this.initWaitCount();
        this.originalDataSource = originalDataSource;
    }

    protected void initAutoCommitEnabled() {
        String param = System.getProperty("jdbcAutoCommit");
        if (param != null) {
            AUTO_COMMIT_ENABLED = Boolean.parseBoolean(param);
        }
    }

    protected void initMaxConnectionsCount() {
        String param = System.getProperty("jdbcMaxConnectionsCount");
        if (param != null) {
            MAX_CONNECTIONS_COUNT = Integer.parseInt(param);
        }
    }

    protected void initWaitTimeout() {
        String param = System.getProperty("jdbcWaitTimeout");
        if (param != null) {
            WAIT_TIMEOUT = Long.parseLong(param);
        }
    }

    protected void initWaitCount() {
        String param = System.getProperty("jdbcWaitCount");
        if (param != null) {
            WAIT_COUNT = Integer.parseInt(param);
        }
    }

    @Override
    public Connection getConnection() throws SQLException {
        this.checkConnections();
        WrappedConnection wrappedConnection = new WrappedConnection(this.originalDataSource.getConnection(), this);
        this.addConnection(wrappedConnection);
        wrappedConnection.setAutoCommit(AUTO_COMMIT_ENABLED);
        logger.debug("Connection acquired: " + wrappedConnection.hashCode() + " count: " + connections.size());
        return wrappedConnection;
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        this.checkConnections();
        WrappedConnection wrappedConnection = new WrappedConnection(this.originalDataSource.getConnection(username, password), this);
        this.addConnection(wrappedConnection);
        wrappedConnection.setAutoCommit(AUTO_COMMIT_ENABLED);
        logger.debug("Connection acquired: " + wrappedConnection.hashCode() + " count: " + connections.size());
        return wrappedConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkConnections() throws SQLException {
        int i = 0;
        while (i < WAIT_COUNT) {
            if (connections.size() == MAX_CONNECTIONS_COUNT) {
                try {
                    WrappedDataSource wrappedDataSource = this;
                    synchronized (wrappedDataSource) {
                        while (this.getOldestConnection().getTimeUsed() < WAIT_TIMEOUT * (long)WAIT_COUNT) {
                            this.wait(WAIT_TIMEOUT);
                        }
                    }
                }
                catch (InterruptedException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            } else {
                return;
            }
            ++i;
        }
        this.forceRelaseConnection();
    }

    private void forceRelaseConnection() throws SQLException {
        logger.debug("entring - forceRelaseConnection()");
        WrappedConnection oldestConnection = this.getOldestConnection();
        if (oldestConnection != null) {
            logger.error("Potential connection leak; victim connection is: " + oldestConnection.hashCode() + ", used (ms): " + oldestConnection.getTimeUsed());
            oldestConnection.close();
        }
        logger.debug("exiting - forceRelaseConnection()");
    }

    protected WrappedConnection getOldestConnection() {
        WrappedConnection oldestConnection = null;
        for (WrappedConnection connection : connections) {
            if (oldestConnection == null) {
                oldestConnection = connection;
            }
            if (oldestConnection.getTimeAcquired() >= connection.getTimeAcquired()) continue;
            oldestConnection = connection;
        }
        return oldestConnection;
    }

    private void addConnection(WrappedConnection connection) {
        connections.add(connection);
    }

    private void removeConnection(WrappedConnection connection) {
        connections.remove(connection);
    }

    public void closedConnection(WrappedConnection wrappedConnection) {
        this.removeConnection(wrappedConnection);
        logger.debug("Connection released: " + wrappedConnection.hashCode() + " count: " + connections.size() + " time used: " + wrappedConnection.getTimeUsed() + "ms");
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return this.originalDataSource.getLogWriter();
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return this.originalDataSource.getLoginTimeout();
    }

    @Override
    public boolean isWrapperFor(Class<?> arg0) throws SQLException {
        return this.originalDataSource.isWrapperFor(arg0);
    }

    @Override
    public void setLogWriter(PrintWriter arg0) throws SQLException {
        this.originalDataSource.setLogWriter(arg0);
    }

    @Override
    public void setLoginTimeout(int arg0) throws SQLException {
        this.originalDataSource.setLoginTimeout(arg0);
    }

    @Override
    public <T> T unwrap(Class<T> arg0) throws SQLException {
        return this.originalDataSource.unwrap(arg0);
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException();
    }
}

