/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.repository.git;

import java.io.File;
import java.io.IOException;
import org.eclipse.dirigible.repository.api.IMasterRepository;
import org.eclipse.dirigible.repository.ext.git.JGitConnector;
import org.eclipse.dirigible.repository.local.FileSystemMasterRepository;
import org.eclipse.dirigible.repository.local.LocalBaseException;
import org.eclipse.dirigible.repository.logging.Logger;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.InvalidRemoteException;
import org.eclipse.jgit.api.errors.TransportException;

public class GitMasterRepository
extends FileSystemMasterRepository
implements IMasterRepository {
    private static final Logger logger = Logger.getLogger(GitMasterRepository.class);
    private String gitLocation;
    private String gitUser;
    private String gitPassword;
    private String gitBranch;

    public GitMasterRepository(String user, String targetFolder, String gitLocation, String gitUser, String gitPassword, String gitBranch) throws LocalBaseException {
        super(user, targetFolder);
        this.gitLocation = gitLocation;
        this.gitUser = gitUser;
        this.gitPassword = gitPassword;
        this.gitBranch = gitBranch;
        try {
            this.reset();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public void reset() throws InvalidRemoteException, TransportException, GitAPIException, IOException {
        File rootFolder = new File(this.getRepositoryPath());
        if (!rootFolder.getParentFile().exists()) {
            JGitConnector.cloneRepository((File)rootFolder.getParentFile(), (String)this.getGitLocation(), (String)this.getGitUser(), (String)this.getGitPassword(), (String)this.getGitBranch());
        }
        JGitConnector gitConnector = new JGitConnector(JGitConnector.getRepository((String)this.getRepositoryPath()));
        gitConnector.pull();
        gitConnector.hardReset();
    }

    public String getGitLocation() {
        return this.gitLocation;
    }

    public String getGitUser() {
        return this.gitUser;
    }

    public String getGitPassword() {
        return this.gitPassword;
    }

    public String getGitBranch() {
        return this.gitBranch;
    }
}

