/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.repository.local;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.io.IOUtils;
import org.eclipse.dirigible.repository.local.FileSystemRepository;
import org.eclipse.dirigible.repository.local.LocalBaseException;

public class ZipRepository
extends FileSystemRepository {
    private String zipRepositoryRootFolder;

    public ZipRepository(String user, String zip) throws LocalBaseException {
        File zipFile = new File(zip);
        if (zipFile.exists()) {
            try {
                Path rootFolder = Files.createTempDirectory("zip_repository", new FileAttribute[0]);
                this.unpackZip(new FileInputStream(zip), rootFolder.toString());
                String zipFileName = zipFile.getName();
                this.zipRepositoryRootFolder = zipFileName.substring(0, zipFileName.lastIndexOf("."));
                this.createRepository(user, rootFolder.toString(), true);
            }
            catch (IOException e) {
                throw new LocalBaseException(e);
            }
        } else {
            throw new LocalBaseException(String.format("Zip file containing Repository content does not exist at path: %s", zip));
        }
    }

    protected void unpackZip(InputStream zip, String folder) throws IOException {
        ZipInputStream zipInputStream = new ZipInputStream(zip);
        try {
            ZipEntry entry;
            while ((entry = zipInputStream.getNextEntry()) != null) {
                File entryDestination = new File(folder, entry.getName());
                if (entry.isDirectory()) {
                    entryDestination.mkdirs();
                    continue;
                }
                entryDestination.getParentFile().mkdirs();
                FileOutputStream out = new FileOutputStream(entryDestination);
                IOUtils.copy((InputStream)zipInputStream, (OutputStream)out);
                ((OutputStream)out).close();
            }
        }
        finally {
            zipInputStream.close();
        }
    }

    protected ZipRepository(String user, String rootFolder, boolean absolute) throws LocalBaseException {
        super(user, rootFolder, absolute);
    }

    protected ZipRepository(String user) throws LocalBaseException {
        super(user);
    }

    protected ZipRepository() throws LocalBaseException {
    }

    @Override
    protected String getRepositoryRootFolder() {
        return this.zipRepositoryRootFolder;
    }
}

