/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.runtime.wiki;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.dirigible.repository.api.IEntity;
import org.eclipse.dirigible.repository.api.IResource;
import org.eclipse.dirigible.repository.logging.Logger;
import org.eclipse.dirigible.runtime.registry.PathUtils;
import org.eclipse.dirigible.runtime.repository.RepositoryFacade;
import org.eclipse.dirigible.runtime.scripting.IScriptExecutor;
import org.eclipse.dirigible.runtime.web.WebRegistryServlet;
import org.eclipse.dirigible.runtime.wiki.WikiExecutor;
import org.eclipse.dirigible.runtime.wiki.WikiProcessor;

public class WikiRegistryServlet
extends WebRegistryServlet {
    private static final Logger logger = Logger.getLogger(WikiRegistryServlet.class);
    private static final String WIKI_CONTENT = "/WikiContent";
    private static final long serialVersionUID = -1484072696377972535L;
    private static final String PARAMETER_NO_HEADER_AND_FOOTER = "nohf";
    protected static final String HEADER_HTML = "header.html";
    protected static final String FOOTER_HTML = "footer.html";
    protected static final String HTML_EXTENSION = ".html";

    protected String extractRepositoryPath(HttpServletRequest request) throws IllegalArgumentException {
        String requestPath = PathUtils.extractPath((HttpServletRequest)request);
        if (request.getAttribute("sandbox") != null && ((Boolean)request.getAttribute("sandbox")).booleanValue()) {
            return "/db/dirigible/sandbox/" + RepositoryFacade.getUser((HttpServletRequest)request) + WIKI_CONTENT + requestPath;
        }
        return "/db/dirigible/registry/public/WikiContent" + requestPath;
    }

    protected boolean isWikiExtensions(IEntity entity) {
        return entity.getName().endsWith(".wiki") || entity.getName().endsWith(".confluence") || entity.getName().endsWith(".markdown") || entity.getName().endsWith(".mdown") || entity.getName().endsWith(".mkdn") || entity.getName().endsWith(".md") || entity.getName().endsWith(".mkd") || entity.getName().endsWith(".mdwn") || entity.getName().endsWith(".textile") || entity.getName().endsWith(".tracwiki") || entity.getName().endsWith(".twiki") || entity.getName().endsWith(".wikis");
    }

    protected byte[] preprocessContent(byte[] rawContent, IEntity entity) throws IOException {
        return WikiProcessor.processContent(rawContent, entity);
    }

    protected String getContentFolder() {
        return WIKI_CONTENT;
    }

    public IScriptExecutor createExecutor(HttpServletRequest request) throws IOException {
        WikiExecutor executor = new WikiExecutor(this.getRepository(request), this.getWebRegistryPath(request), "/db/dirigible/registry/public/WikiContent");
        return executor;
    }

    protected byte[] buildResourceData(IEntity entity, HttpServletRequest request, HttpServletResponse response) throws IOException {
        boolean list;
        byte[] rawContent = this.retrieveResourceData(entity, request, response);
        boolean nohf = request.getParameter(PARAMETER_NO_HEADER_AND_FOOTER) != null;
        boolean bl = list = request.getParameter("list") != null;
        if (list) {
            return super.buildResourceData(entity, request, response);
        }
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        if (this.isWikiExtensions(entity)) {
            IResource header = entity.getParent().getResource(HEADER_HTML);
            if (!nohf && header.exists()) {
                outputStream.write(header.getContent());
            }
        }
        if (this.isWikiExtensions(entity)) {
            outputStream.write(this.preprocessContent(rawContent, entity));
        } else {
            outputStream.write(rawContent);
        }
        if (this.isWikiExtensions(entity)) {
            IResource footer = entity.getParent().getResource(FOOTER_HTML);
            if (!nohf && footer.exists()) {
                outputStream.write(footer.getContent());
            }
        }
        outputStream.flush();
        return outputStream.toByteArray();
    }
}

