/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.repository.datasource.db.dialect;

import org.eclipse.dirigible.repository.datasource.DBSupportedTypesMap;
import org.eclipse.dirigible.repository.datasource.db.dialect.RDBGenericDialectSpecifier;

public class HANADBSpecifier
extends RDBGenericDialectSpecifier {
    public static final String PRODUCT_HDB = "HDB";
    private static final String LIMIT_D_OFFSET_D = "LIMIT %d OFFSET %d";
    private static final String HANA_FLOAT = "DOUBLE";
    private static final String HANA_TIMESTAMP = "TIMESTAMP";
    private static final String HANA_BLOB = "BLOB";
    private static final String HANA_CURRENT_TIMESTAMP = "CURRENT_TIMESTAMP";
    private static final String HANA_KEY_VARCHAR = "VARCHAR(1000)";
    private static final String HANA_BIG_VARCHAR = "VARCHAR(4000)";

    @Override
    public String createLimitAndOffset(int limit, int offset) {
        return String.format(LIMIT_D_OFFSET_D, limit, offset);
    }

    @Override
    public boolean isSchemaFilterSupported() {
        return false;
    }

    @Override
    public String getSchemaFilterScript() {
        return "";
    }

    @Override
    public String getAlterAddOpen() {
        return " ADD ( ";
    }

    @Override
    public String getAlterAddClose() {
        return " ) ";
    }

    @Override
    public String specify(String sql) {
        sql = sql.replace("$CURRENT_TIMESTAMP$", HANA_CURRENT_TIMESTAMP);
        sql = sql.replace("$TIMESTAMP$", HANA_TIMESTAMP);
        sql = sql.replace("$BLOB$", HANA_BLOB);
        sql = sql.replace("$KEY_VARCHAR$", HANA_KEY_VARCHAR);
        sql = sql.replace("$BIG_VARCHAR$", HANA_BIG_VARCHAR);
        return sql;
    }

    @Override
    public String getSpecificType(String commonType) {
        if (DBSupportedTypesMap.DataTypes.FLOAT.equals((Object)DBSupportedTypesMap.DataTypes.valueOf((String)commonType))) {
            return HANA_FLOAT;
        }
        return commonType;
    }

    @Override
    public boolean isDialectForName(String productName) {
        return PRODUCT_HDB.equalsIgnoreCase(productName);
    }
}

