/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.repository.ext.db.model;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import org.eclipse.dirigible.repository.ext.db.model.DataStructureModel;
import org.eclipse.dirigible.repository.ext.db.model.EDataStructureModelFormatException;

public class ViewModel
extends DataStructureModel {
    private static final String VIEW = "VIEW";
    private static final String VIEW_NAME = "viewName";
    private static final String QUERY = "query";
    private String query;

    public ViewModel(String content) throws EDataStructureModelFormatException {
        this.setType(VIEW);
        JsonParser parser = new JsonParser();
        JsonObject definitionObject = (JsonObject)parser.parse(content);
        JsonElement nameElement = definitionObject.get(VIEW_NAME);
        if (nameElement == null) {
            throw new EDataStructureModelFormatException(String.format(DataStructureModel.ELEMENT_S_DOES_NOT_EXIST_IN_THIS_MODEL_S, VIEW_NAME, content));
        }
        this.setName(nameElement.getAsString());
        JsonElement queryElement = definitionObject.get(QUERY);
        if (queryElement == null) {
            throw new EDataStructureModelFormatException(String.format(DataStructureModel.ELEMENT_S_DOES_NOT_EXIST_IN_THIS_MODEL_S, QUERY, this.getName()));
        }
        this.setQuery(queryElement.getAsString());
        this.fillDependencies(definitionObject);
    }

    public String getQuery() {
        return this.query;
    }

    public void setQuery(String query) {
        this.query = query;
    }
}

