/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.runtime.js.rhino;

import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.dirigible.repository.logging.Logger;
import org.eclipse.dirigible.runtime.js.rhino.RepositoryModuleSourceProvider;
import org.eclipse.dirigible.runtime.scripting.IBaseScriptExecutor;
import org.eclipse.dirigible.runtime.scripting.IJavaScriptEngineExecutor;
import org.eclipse.dirigible.runtime.scripting.IJavaScriptExecutor;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.EcmaError;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.commonjs.module.ModuleScriptProvider;
import org.mozilla.javascript.commonjs.module.Require;
import org.mozilla.javascript.commonjs.module.RequireBuilder;
import org.mozilla.javascript.commonjs.module.provider.ModuleSource;
import org.mozilla.javascript.commonjs.module.provider.ModuleSourceProvider;
import org.mozilla.javascript.commonjs.module.provider.SoftCachingModuleScriptProvider;

public class RhinoJavaScriptEngineExecutor
implements IJavaScriptEngineExecutor {
    private static final Logger logger = Logger.getLogger(RhinoJavaScriptEngineExecutor.class);
    private IJavaScriptExecutor javaScriptExecutor;

    public RhinoJavaScriptEngineExecutor(IJavaScriptExecutor javaScriptExecutor) {
        this.javaScriptExecutor = javaScriptExecutor;
    }

    public Object executeServiceModule(HttpServletRequest request, HttpServletResponse response, Object input, String module, Map<Object, Object> executionContext) throws IOException {
        Object result;
        block10: {
            logger.debug("entering: executeServiceModule()");
            logger.debug("module=" + module);
            if (module == null) {
                throw new IOException("JavaScript module name cannot be null");
            }
            RepositoryModuleSourceProvider sourceProvider = this.createRepositoryModuleSourceProvider();
            SoftCachingModuleScriptProvider scriptProvider = new SoftCachingModuleScriptProvider((ModuleSourceProvider)sourceProvider);
            RequireBuilder builder = new RequireBuilder();
            builder.setModuleScriptProvider((ModuleScriptProvider)scriptProvider);
            builder.setSandboxed(false);
            result = null;
            Context context = Context.enter();
            try {
                context.setLanguageVersion(120);
                context.getWrapFactory().setJavaPrimitiveWrap(false);
                ScriptableObject topLevelScope = context.initStandardObjects();
                Require require = builder.createRequire(context, (Scriptable)topLevelScope);
                require.install((Scriptable)topLevelScope);
                topLevelScope.put("engine", (Scriptable)topLevelScope, (Object)"rhino");
                this.javaScriptExecutor.registerDefaultVariables(request, response, input, executionContext, this.javaScriptExecutor.getRepository(), (Object)topLevelScope);
                this.javaScriptExecutor.beforeExecution(request, response, module, (Object)context);
                try {
                    ModuleSource moduleSource = sourceProvider.loadSource(module, null, null);
                    try {
                        result = context.evaluateReader((Scriptable)topLevelScope, moduleSource.getReader(), module, 0, null);
                    }
                    catch (EcmaError e) {
                        if (e.getMessage() != null && e.getMessage().contains("\"exports\" is not defined")) {
                            result = "Requested endpoint is not a service, but rather a library.";
                            logger.error(e.getMessage());
                            break block10;
                        }
                        logger.error(e.getMessage(), (Throwable)e);
                    }
                    catch (Throwable e) {
                        logger.error(e.getMessage(), e);
                    }
                }
                catch (URISyntaxException e) {
                    throw new IOException(e.getMessage(), e);
                }
            }
            finally {
                Context.exit();
            }
        }
        logger.debug("exiting: executeServiceModule()");
        return result;
    }

    private RepositoryModuleSourceProvider createRepositoryModuleSourceProvider() {
        RepositoryModuleSourceProvider repositoryModuleSourceProvider = null;
        repositoryModuleSourceProvider = new RepositoryModuleSourceProvider((IBaseScriptExecutor)this.javaScriptExecutor, this.javaScriptExecutor.getRepository(), this.javaScriptExecutor.getRootPaths());
        return repositoryModuleSourceProvider;
    }
}

