/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.runtime.filter;

import java.io.IOException;
import java.security.Principal;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.sql.DataSource;
import org.eclipse.dirigible.repository.api.IRepository;
import org.eclipse.dirigible.repository.api.RepositoryException;
import org.eclipse.dirigible.repository.datasource.DataSourceFacade;
import org.eclipse.dirigible.repository.ext.security.SecurityManager;
import org.eclipse.dirigible.repository.logging.Logger;
import org.eclipse.dirigible.runtime.filter.AbstractRegistrySecureFilter;
import org.eclipse.dirigible.runtime.registry.Messages;
import org.eclipse.dirigible.runtime.registry.PathUtils;
import org.eclipse.dirigible.runtime.repository.RepositoryFacade;

public class RegistrySecureRolesFilter
extends AbstractRegistrySecureFilter {
    private static final String YOU_DO_NOT_HAVE_REQUIRED_ROLE_S_TO_ACCESS_THIS_LOCATION = Messages.getString((String)"RegistrySecureRolesFilter.YOU_DO_NOT_HAVE_REQUIRED_ROLE_S_TO_ACCESS_THIS_LOCATION");
    private static final Logger logger = Logger.getLogger(RegistrySecureRolesFilter.class);

    @Override
    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)req;
        String location = PathUtils.extractPath((HttpServletRequest)request);
        String securedLocationConstraint = this.isLocationSecured(location);
        if (securedLocationConstraint != null && !this.isUserInRole(req, securedLocationConstraint)) {
            logger.debug(String.format("Location: %s is forbidden", securedLocationConstraint));
            ((HttpServletResponse)res).sendError(403, YOU_DO_NOT_HAVE_REQUIRED_ROLE_S_TO_ACCESS_THIS_LOCATION);
            return;
        }
        chain.doFilter(req, res);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isUserInRole(ServletRequest req, String location) {
        try {
            String role;
            if (!(req instanceof HttpServletRequest)) return false;
            HttpServletRequest request = (HttpServletRequest)req;
            Principal principal = request.getUserPrincipal();
            if (principal == null) return false;
            SecurityManager securityManager = SecurityManager.getInstance((IRepository)RepositoryFacade.getInstance().getRepository(request), (DataSource)DataSourceFacade.getInstance().getDataSource(request));
            List roles = securityManager.getRolesForLocation(location);
            Iterator iterator = roles.iterator();
            do {
                if (iterator.hasNext()) continue;
                logger.warn(String.format("Access to the location: %s for the user: %s NOT allowed", location, principal.getName()));
                return false;
            } while (!request.isUserInRole(role = (String)iterator.next()));
            logger.debug(String.format("Allowed access to the location: %s for the user: %s who has the role: %s", location, principal.getName(), role));
            return true;
        }
        catch (RepositoryException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return false;
        }
        catch (SQLException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return false;
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return false;
    }

    @Override
    protected String getSecuredMapping() {
        return null;
    }
}

