/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.resources.semantic;

import org.eclipse.core.resources.semantic.ISemanticResourceStatus;
import org.eclipse.core.resources.semantic.SemanticResourceStatusCode;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Status;

final class SemanticResourceStatus
extends Status
implements ISemanticResourceStatus {
    private final IPath path;

    private SemanticResourceStatus(int type, SemanticResourceStatusCode code, IPath path, String message, Throwable exception) {
        super(type, "org.eclipse.core.resources.semantic.shared", code.toInt(), message, exception);
        if (message == null && exception != null) {
            this.setMessage(exception.getMessage());
        }
        this.path = path;
    }

    SemanticResourceStatus(SemanticResourceStatusCode code, IPath path, String message, Throwable exception) {
        this(SemanticResourceStatus.getSeverity(code), code, path, message, exception);
    }

    public IPath getPath() {
        return this.path;
    }

    protected static int getSeverity(SemanticResourceStatusCode scode) {
        int code = scode.toInt();
        return code == 0 ? 0 : 1 << code % 100 / 33;
    }

    private String getTypeName() {
        switch (this.getSeverity()) {
            case 0: {
                return "OK";
            }
            case 4: {
                return "ERROR";
            }
            case 1: {
                return "INFO";
            }
            case 2: {
                return "WARNING";
            }
        }
        return String.valueOf(this.getSeverity());
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("[type: ");
        sb.append(this.getTypeName());
        sb.append("], [path: ");
        sb.append(this.getPath());
        sb.append("], [message: ");
        sb.append(this.getMessage());
        sb.append("], [plugin: ");
        sb.append(this.getPlugin());
        sb.append("], [exception: ");
        sb.append(this.getException());
        sb.append("]\n");
        return sb.toString();
    }
}

