/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.core.internal.tests.contexts.inject;

import javax.inject.Inject;
import javax.inject.Named;
import junit.framework.TestCase;
import org.eclipse.e4.core.contexts.ContextFunction;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;

public class InjectionUpdateTest
extends TestCase {
    private IEclipseContext c1;
    private IEclipseContext c21;
    private IEclipseContext c22;

    protected void setUp() throws Exception {
        super.setUp();
        this.c1 = EclipseContextFactory.create((String)"c1");
        this.c1.set("id", (Object)"c1");
        this.c21 = this.c1.createChild("c21");
        this.c21.set("id", (Object)"c21");
        this.c1.set("c21", (Object)this.c21);
        this.c22 = this.c1.createChild("c22");
        this.c22.set("id", (Object)"c22");
        this.c1.set("c22", (Object)this.c22);
    }

    public void testPropagation() {
        this.c1.set("base", (Object)"abc");
        this.c21.set("derived1", (Object)new ContextFunction(){

            public Object compute(IEclipseContext context) {
                String baseString = (String)context.get("base");
                return String.valueOf(baseString.charAt(0)) + "_";
            }
        });
        this.c22.set("derived2", (Object)new ContextFunction(){

            public Object compute(IEclipseContext context) {
                String baseString = (String)context.get("base");
                return "_" + baseString.charAt(baseString.length() - 1);
            }
        });
        this.c1.set("calculated", (Object)new ContextFunction(){

            public Object compute(IEclipseContext context) {
                IEclipseContext context21 = (IEclipseContext)context.get("c21");
                String derived1 = (String)context21.get("derived1");
                IEclipseContext context22 = (IEclipseContext)context.get("c22");
                String derived2 = (String)context22.get("derived2");
                return String.valueOf(derived1) + derived2;
            }
        });
        PropagationTest testObject = (PropagationTest)ContextInjectionFactory.make(PropagationTest.class, (IEclipseContext)this.c1);
        InjectionUpdateTest.assertNotNull((Object)testObject);
        InjectionUpdateTest.assertEquals((int)1, (int)testObject.called);
        InjectionUpdateTest.assertEquals((String)"a__c", (String)testObject.in);
        this.c1.set("base", (Object)"123");
        InjectionUpdateTest.assertEquals((int)2, (int)testObject.called);
        InjectionUpdateTest.assertEquals((String)"1__3", (String)testObject.in);
        this.c1.set("base", (Object)"xyz");
        InjectionUpdateTest.assertEquals((int)3, (int)testObject.called);
        InjectionUpdateTest.assertEquals((String)"x__z", (String)testObject.in);
    }

    public static class PropagationTest {
        public int called = 0;
        public String in;

        @Inject
        public PropagationTest() {
        }

        @Inject
        public void setCalculated(@Named(value="calculated") String string) {
            ++this.called;
            this.in = string;
        }
    }
}

