/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.demo.contacts.processors;

import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.e4.demo.contacts.processors.AbstractThemeProcessor;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.commands.MCommand;
import org.eclipse.e4.ui.model.application.commands.MParameter;
import org.eclipse.e4.ui.model.application.ui.menu.MHandledMenuItem;
import org.eclipse.e4.ui.model.application.ui.menu.MMenu;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuFactory;
import org.eclipse.emf.ecore.EObject;

public class MenuThemeProcessor
extends AbstractThemeProcessor {
    @Inject
    @Named(value="menu:org.eclipse.ui.main.menu")
    private MMenu menu;
    private MMenu themesMenu;

    protected boolean check() {
        return this.menu != null;
    }

    protected void preprocess() {
        this.themesMenu = MMenuFactory.INSTANCE.createMenu();
        this.themesMenu.setLabel("Theme");
    }

    protected void processTheme(String name, MCommand switchCommand, MParameter themeId, String iconURI) {
        MHandledMenuItem menuItem = MMenuFactory.INSTANCE.createHandledMenuItem();
        menuItem.setLabel(name);
        menuItem.setCommand(switchCommand);
        menuItem.getParameters().add(themeId);
        if (iconURI != null) {
            menuItem.setIconURI(iconURI);
        }
        this.themesMenu.getChildren().add(menuItem);
    }

    protected void postprocess() {
        this.menu.getChildren().add(this.themesMenu);
    }

    protected MApplication getApplication() {
        return (MApplication)((EObject)this.menu).eContainer().eContainer();
    }
}

