/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.emf.ecore.javascript;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.e4.emf.ecore.javascript.EmfContext;
import org.eclipse.e4.emf.ecore.javascript.JavascriptSupport;
import org.eclipse.e4.emf.ecore.javascript.JavascriptSupportWrapper;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.mozilla.javascript.Scriptable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class EObjectWrapper
extends JavascriptSupportWrapper {
    private static Logger log = Logger.getLogger(EObjectWrapper.class.getName());

    protected EObjectWrapper(JavascriptSupport javascriptSupport, Scriptable scope, EObject eObject, Class<?> staticType, EClassifier prototypeClass) {
        super(javascriptSupport, scope, eObject, staticType, prototypeClass);
    }

    public EObjectWrapper(JavascriptSupport javascriptSupport, Scriptable scope, EObject eObject, Class<?> staticType) {
        this(javascriptSupport, scope, eObject, staticType, (EClassifier)eObject.eClass());
    }

    private EStructuralFeature getFeature(String name, EObject eObject) {
        EClass eClass = eObject.eClass();
        if (name.length() == 0 || "$".equals(name)) {
            EReference eContainmentFeature = eObject.eContainmentFeature();
            return eContainmentFeature != null ? eContainmentFeature.getEOpposite() : null;
        }
        return eClass.getEStructuralFeature(name);
    }

    @Override
    public boolean has(String name, Scriptable start) {
        EObject eObject = (EObject)this.javaObject;
        EStructuralFeature feature = this.getFeature(name, eObject);
        if (feature != null) {
            return true;
        }
        for (EObject content : eObject.eContents()) {
            if (!this.javascriptSupport.hasName(name, content)) continue;
            return true;
        }
        return super.has(name, start);
    }

    @Override
    public Object get(String name, Scriptable start) {
        EObject eObject = (EObject)this.javaObject;
        EStructuralFeature feature = this.getFeature(name, eObject);
        if (feature != null) {
            Object value = eObject.eGet(feature);
            EmfContext.noteDependency(eObject, feature, value);
            return this.javascriptSupport.wrap(value);
        }
        for (EObject content : eObject.eContents()) {
            if (!this.javascriptSupport.hasName(name, content)) continue;
            feature = this.javascriptSupport.getNameFeature(content);
            EmfContext.noteDependency(content, feature, this.javascriptSupport.getName(content));
            return this.javascriptSupport.wrap(content);
        }
        return super.get(name, start);
    }

    @Override
    public void put(String name, Scriptable start, Object value) {
        EObject eObject = (EObject)this.javaObject;
        EStructuralFeature feature = this.getFeature(name, eObject);
        if (feature != null) {
            Object unwrappedValue;
            EClassifier type = feature.getEType();
            Object object = unwrappedValue = value != null ? this.javascriptSupport.unwrapTo(value, type.getInstanceClass()) : null;
            if (unwrappedValue != null && !type.isInstance(unwrappedValue)) {
                log.log(Level.SEVERE, "Unsupported conversion from " + value + " to " + type + ": " + unwrappedValue);
            }
            eObject.eSet(feature, unwrappedValue);
            return;
        }
        super.put(name, start, value);
    }

    public Object[] getIds() {
        EObject eObject = (EObject)this.javaObject;
        EClass eClass = eObject.eClass();
        ArrayList<Object> ids = this.isEmfOnly() ? new ArrayList<Object>() : new ArrayList<Object>(Arrays.asList(super.getIds()));
        ids.addAll(Arrays.asList(this.getPrototype().getIds()));
        ids.addAll((Collection<Object>)eClass.getEAllStructuralFeatures());
        this.addParentId(eObject, ids);
        this.addNameIds((List<EObject>)eObject.eContents(), ids);
        this.addIndexIds(eObject.eContents().size(), ids);
        return ids.toArray();
    }

    public boolean has(int index, Scriptable start) {
        EObject eObject = (EObject)this.javaObject;
        return this.has((List<?>)eObject.eContents(), index, start);
    }

    public Object get(int index, Scriptable start) {
        EObject eObject = (EObject)this.javaObject;
        return this.get((List<?>)eObject.eContents(), index, start);
    }

    public void put(int index, Scriptable start, Object value) {
        EObject eObject = (EObject)this.javaObject;
        this.put((List)eObject.eContents(), index, start, value);
    }
}

