/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.tools.emf.editor3x;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.e4.tools.emf.ui.common.IModelResource;
import org.eclipse.e4.ui.internal.workbench.E4XMIResourceFactory;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.command.CommandStackListener;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;

public class XMIModelResource
implements IModelResource {
    private EditingDomain editingDomain;
    private Resource resource;
    private List<IModelResource.ModelListener> listeners = new ArrayList<IModelResource.ModelListener>();
    private boolean dirty;

    public XMIModelResource(URI uri) {
        ComposedAdapterFactory adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        BasicCommandStack commandStack = new BasicCommandStack();
        commandStack.addCommandStackListener(new CommandStackListener(){

            public void commandStackChanged(EventObject event) {
                XMIModelResource.this.dirty = true;
                XMIModelResource.this.fireDirtyChanged();
                XMIModelResource.this.fireCommandStackChanged();
            }
        });
        this.editingDomain = new AdapterFactoryEditingDomain((AdapterFactory)adapterFactory, (CommandStack)commandStack, (ResourceSet)resourceSet);
        resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("*", new E4XMIResourceFactory());
        this.resource = resourceSet.getResource(uri, true);
    }

    public IObservableList getRoot() {
        WritableList list = new WritableList();
        list.add(this.resource.getContents().get(0));
        return list;
    }

    public EditingDomain getEditingDomain() {
        return this.editingDomain;
    }

    public boolean isSaveable() {
        return true;
    }

    public void addModelListener(IModelResource.ModelListener listener) {
        this.listeners.add(listener);
    }

    public void removeModelListener(IModelResource.ModelListener listener) {
        this.listeners.remove(listener);
    }

    public boolean isDirty() {
        return this.dirty && this.getEditingDomain().getCommandStack().canUndo();
    }

    private void fireDirtyChanged() {
        for (IModelResource.ModelListener listener : this.listeners) {
            listener.dirtyChanged();
        }
    }

    private void fireCommandStackChanged() {
        for (IModelResource.ModelListener listener : this.listeners) {
            listener.commandStackChanged();
        }
    }

    public IStatus save() {
        HashMap map = new HashMap();
        try {
            this.resource.save(map);
            this.editingDomain.getCommandStack().flush();
            this.dirty = false;
            this.fireDirtyChanged();
            this.fireCommandStackChanged();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return Status.OK_STATUS;
    }
}

