/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.tools.emf.ui.internal.common.component;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.conversion.Converter;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.e4.tools.emf.ui.common.EStackLayout;
import org.eclipse.e4.tools.emf.ui.common.IModelResource;
import org.eclipse.e4.tools.emf.ui.common.Util;
import org.eclipse.e4.tools.emf.ui.common.component.AbstractComponentEditor;
import org.eclipse.e4.tools.emf.ui.internal.Messages;
import org.eclipse.e4.tools.emf.ui.internal.common.ModelEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.ControlFactory;
import org.eclipse.e4.tools.emf.ui.internal.common.component.dialogs.SharedElementsDialog;
import org.eclipse.e4.ui.model.application.impl.ApplicationPackageImpl;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.MUILabel;
import org.eclipse.e4.ui.model.application.ui.advanced.MPlaceholder;
import org.eclipse.e4.ui.model.application.ui.advanced.impl.AdvancedPackageImpl;
import org.eclipse.e4.ui.model.application.ui.impl.UiPackageImpl;
import org.eclipse.emf.databinding.EMFDataBindingContext;
import org.eclipse.emf.databinding.edit.EMFEditProperties;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.databinding.swt.IWidgetValueProperty;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class PlaceholderEditor
extends AbstractComponentEditor {
    private Composite composite;
    private Image image;
    private EMFDataBindingContext context;
    private IModelResource resource;
    private EStackLayout stackLayout;

    public PlaceholderEditor(EditingDomain editingDomain, ModelEditor editor, IModelResource resource) {
        super(editingDomain, editor);
        this.resource = resource;
    }

    public Image getImage(Object element, Display display) {
        if (this.image == null) {
            try {
                this.image = this.loadSharedImage(display, new URL("platform:/plugin/org.eclipse.e4.tools.emf.ui/icons/full/modelelements/Placeholder.gif"));
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
        }
        return this.image;
    }

    public String getLabel(Object element) {
        return Messages.PlaceholderEditor_Label;
    }

    public String getDetailLabel(Object element) {
        MPlaceholder pl = (MPlaceholder)element;
        if (pl.getRef() != null) {
            StringBuilder b = new StringBuilder();
            b.append(((EObject)pl.getRef()).eClass().getName());
            if (pl.getRef() instanceof MUILabel) {
                MUILabel label = (MUILabel)pl.getRef();
                if (label.getLabel() != null && label.getLabel().trim().length() > 0) {
                    b.append(" (" + label.getLabel() + ")");
                } else if (label.getTooltip() != null && label.getTooltip().trim().length() > 0) {
                    b.append(" (" + label.getTooltip() + ")");
                } else if (pl.getRef().getElementId() != null && pl.getRef().getElementId().trim().length() > 0) {
                    b.append(pl.getRef().getElementId());
                }
            } else if (pl.getRef().getElementId() != null && pl.getRef().getElementId().trim().length() > 0) {
                b.append(" (" + pl.getRef().getElementId() + ")");
            }
            return b.toString();
        }
        return null;
    }

    public String getDescription(Object element) {
        return Messages.PlaceholderEditor_Descriptor;
    }

    public Composite getEditor(Composite parent, Object object) {
        Control topControl;
        if (this.composite == null) {
            this.context = new EMFDataBindingContext();
            if (this.getEditor().isModelFragment()) {
                this.composite = new Composite(parent, 0);
                this.stackLayout = new EStackLayout();
                this.composite.setLayout((Layout)this.stackLayout);
                this.createForm(this.composite, this.context, this.getMaster(), false);
                this.createForm(this.composite, this.context, this.getMaster(), true);
            } else {
                this.composite = this.createForm(parent, this.context, this.getMaster(), false);
            }
        }
        if (this.getEditor().isModelFragment() && this.stackLayout.topControl != (topControl = Util.isImport((EObject)object) ? this.composite.getChildren()[1] : this.composite.getChildren()[0])) {
            this.stackLayout.topControl = topControl;
            this.composite.layout(true, true);
        }
        this.getMaster().setValue(object);
        return this.composite;
    }

    private Composite createForm(Composite parent, EMFDataBindingContext context, WritableValue master, boolean isImport) {
        parent = new Composite(parent, 0);
        GridLayout gl = new GridLayout(3, false);
        gl.horizontalSpacing = 10;
        parent.setLayout((Layout)gl);
        if (this.getEditor().isShowXMIId() || this.getEditor().isLiveModel()) {
            ControlFactory.createXMIId(parent, this);
        }
        IWidgetValueProperty textProp = WidgetProperties.text((int)24);
        if (isImport) {
            ControlFactory.createFindImport(parent, this, context);
            return parent;
        }
        Label l = new Label(parent, 0);
        l.setText(Messages.ModelTooling_Common_Id);
        l.setLayoutData((Object)new GridData(128));
        Text t = new Text(parent, 2048);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        t.setLayoutData((Object)gd);
        context.bindValue((IObservableValue)textProp.observeDelayed(200, (Widget)t), EMFEditProperties.value((EditingDomain)this.getEditingDomain(), (EStructuralFeature)ApplicationPackageImpl.Literals.APPLICATION_ELEMENT__ELEMENT_ID).observeDetail((IObservableValue)this.getMaster()));
        l = new Label(parent, 0);
        l.setText(Messages.PlaceholderEditor_Reference);
        l.setLayoutData((Object)new GridData(128));
        t = new Text(parent, 2048);
        t.setEditable(false);
        gd = new GridData(768);
        t.setLayoutData((Object)gd);
        UpdateValueStrategy t2m = new UpdateValueStrategy();
        t2m.setConverter((IConverter)new Converter(String.class, MUIElement.class){

            public Object convert(Object fromObject) {
                return null;
            }
        });
        UpdateValueStrategy m2t = new UpdateValueStrategy();
        m2t.setConverter((IConverter)new Converter(MUIElement.class, String.class){

            public Object convert(Object fromObject) {
                if (fromObject != null) {
                    MUILabel label;
                    EObject o = (EObject)fromObject;
                    if (o instanceof MUILabel && !Util.isNullOrEmpty((label = (MUILabel)o).getLabel())) {
                        return String.valueOf(o.eClass().getName()) + " - " + label.getLabel();
                    }
                    return String.valueOf(o.eClass().getName()) + " - " + ((MUIElement)fromObject).getElementId();
                }
                return null;
            }
        });
        context.bindValue((IObservableValue)textProp.observe((Widget)t), EMFEditProperties.value((EditingDomain)this.getEditingDomain(), (EStructuralFeature)AdvancedPackageImpl.Literals.PLACEHOLDER__REF).observeDetail((IObservableValue)this.getMaster()), t2m, m2t);
        final Button b = new Button(parent, 0x800008);
        b.setImage(this.getImage(b.getDisplay(), 0));
        b.setText(Messages.ModelTooling_Common_FindEllipsis);
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SharedElementsDialog dialog = new SharedElementsDialog(b.getShell(), PlaceholderEditor.this.getEditor(), (MPlaceholder)PlaceholderEditor.this.getMaster().getValue(), PlaceholderEditor.this.resource);
                dialog.open();
            }
        });
        ControlFactory.createCheckBox(parent, Messages.ModelTooling_UIElement_ToBeRendered, (IObservableValue)this.getMaster(), context, WidgetProperties.selection(), EMFEditProperties.value((EditingDomain)this.getEditingDomain(), (EStructuralFeature)UiPackageImpl.Literals.UI_ELEMENT__TO_BE_RENDERED));
        ControlFactory.createCheckBox(parent, Messages.ModelTooling_UIElement_Visible, (IObservableValue)this.getMaster(), context, WidgetProperties.selection(), EMFEditProperties.value((EditingDomain)this.getEditingDomain(), (EStructuralFeature)UiPackageImpl.Literals.UI_ELEMENT__VISIBLE));
        ControlFactory.createStringListWidget(parent, this, Messages.ModelTooling_ApplicationElement_Tags, (EStructuralFeature)ApplicationPackageImpl.Literals.APPLICATION_ELEMENT__TAGS, 10);
        return parent;
    }

    public IObservableList getChildList(Object element) {
        return null;
    }
}

