/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.tools.emf.ui.internal.common.component.dialogs;

import java.util.ArrayList;
import org.eclipse.e4.tools.emf.ui.common.IModelResource;
import org.eclipse.e4.tools.emf.ui.internal.Messages;
import org.eclipse.e4.tools.emf.ui.internal.PatternFilter;
import org.eclipse.e4.ui.model.application.commands.MBindingContext;
import org.eclipse.e4.ui.model.application.commands.impl.CommandsPackageImpl;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class BindingContextSelectionDialog
extends TitleAreaDialog {
    private IModelResource resource;
    private TableViewer viewer;
    private String selectedId;

    public BindingContextSelectionDialog(Shell parentShell, IModelResource resource) {
        super(parentShell);
        this.resource = resource;
    }

    public String getSelectedId() {
        return this.selectedId;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.getShell().setText(Messages.BindingContextSelectionDialog_ShellTitle);
        this.setTitle(Messages.BindingContextSelectionDialog_Title);
        this.setMessage(Messages.BindingContextSelectionDialog_Message);
        final Image titleImage = new Image((Device)composite.getDisplay(), ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("/icons/full/wizban/newexp_wiz.png"));
        this.setTitleImage(titleImage);
        this.getShell().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                titleImage.dispose();
            }
        });
        Composite container = new Composite(composite, 0);
        container.setLayoutData((Object)new GridData(1808));
        container.setLayout((Layout)new GridLayout(2, false));
        Label l = new Label(container, 0);
        l.setText(Messages.BindingContextSelectionDialog_LabelContextId);
        Text searchText = new Text(container, 2688);
        searchText.setLayoutData((Object)new GridData(768));
        new Label(container, 0);
        this.viewer = new TableViewer(container);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new LabelProviderImpl());
        this.viewer.getControl().setLayoutData((Object)new GridData(1808));
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                BindingContextSelectionDialog.this.okPressed();
            }
        });
        ArrayList<EObject> categories = new ArrayList<EObject>();
        TreeIterator it = EcoreUtil.getAllContents((EObject)((EObject)this.resource.getRoot().get(0)), (boolean)true);
        while (it.hasNext()) {
            EObject o = (EObject)it.next();
            if (o.eClass() != CommandsPackageImpl.Literals.BINDING_CONTEXT) continue;
            categories.add(o);
        }
        this.viewer.setInput(categories);
        final PatternFilter filter = new PatternFilter(){

            protected boolean isParentMatch(Viewer viewer, Object element) {
                return viewer instanceof AbstractTreeViewer && super.isParentMatch(viewer, element);
            }
        };
        this.viewer.addFilter((ViewerFilter)filter);
        searchText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                filter.setPattern(((Text)e.widget).getText());
                BindingContextSelectionDialog.this.viewer.refresh();
            }
        });
        return composite;
    }

    protected void okPressed() {
        IStructuredSelection s = (IStructuredSelection)this.viewer.getSelection();
        if (!s.isEmpty()) {
            this.selectedId = ((MBindingContext)s.getFirstElement()).getElementId();
            if (this.selectedId != null && this.selectedId.trim().length() > 0) {
                super.okPressed();
            } else {
                this.setErrorMessage(Messages.BindingContextSelectionDialog_NoIdReference);
            }
        }
    }

    private static class LabelProviderImpl
    extends StyledCellLabelProvider
    implements ILabelProvider {
        private LabelProviderImpl() {
        }

        public void update(ViewerCell cell) {
            MBindingContext cmd = (MBindingContext)cell.getElement();
            StyledString styledString = new StyledString();
            if (cmd.getName() != null) {
                styledString.append(cmd.getName());
            }
            if (cmd.getElementId() != null) {
                styledString.append(" (" + cmd.getElementId() + ")", StyledString.DECORATIONS_STYLER);
            } else {
                styledString.append(" (<no id>)", StyledString.DECORATIONS_STYLER);
            }
            if (cmd.getDescription() != null) {
                styledString.append(" - " + cmd.getDescription(), StyledString.DECORATIONS_STYLER);
            }
            cell.setText(styledString.getString());
            cell.setStyleRanges(styledString.getStyleRanges());
        }

        public Image getImage(Object element) {
            return null;
        }

        public String getText(Object element) {
            MBindingContext command = (MBindingContext)element;
            String s = "";
            if (command.getName() != null) {
                s = String.valueOf(s) + command.getName();
            }
            if (command.getDescription() != null) {
                s = String.valueOf(s) + " " + command.getDescription();
            }
            if (command.getElementId() != null) {
                s = String.valueOf(s) + " " + command.getElementId();
            }
            return s;
        }
    }
}

