/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.tools.emf.ui.internal.common.component.dialogs;

import java.text.BreakIterator;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.e4.tools.emf.ui.common.Util;
import org.eclipse.e4.tools.emf.ui.internal.Messages;
import org.eclipse.e4.tools.emf.ui.internal.StringMatcher;
import org.eclipse.e4.ui.model.fragment.MStringModelFragment;
import org.eclipse.e4.ui.model.fragment.impl.FragmentPackageImpl;
import org.eclipse.e4.ui.model.internal.ModelUtils;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EGenericType;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class FeatureSelectionDialog
extends TitleAreaDialog {
    private TreeViewer viewer;
    private MStringModelFragment fragment;
    private EditingDomain editingDomain;

    public FeatureSelectionDialog(Shell parentShell, EditingDomain editingDomain, MStringModelFragment fragment) {
        super(parentShell);
        this.fragment = fragment;
        this.editingDomain = editingDomain;
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText(Messages.FeatureSelectionDialog_ShellTitle);
        this.setTitle(Messages.FeatureSelectionDialog_DialogTitle);
        this.setMessage(Messages.FeatureSelectionDialog_DialogMessage);
        Composite composite = (Composite)super.createDialogArea(parent);
        final Image packageImage = new Image((Device)this.getShell().getDisplay(), ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("/icons/full/obj16/EPackage.gif"));
        final Image classImage = new Image((Device)this.getShell().getDisplay(), ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("/icons/full/obj16/class_obj.gif"));
        final Image featureImage = new Image((Device)this.getShell().getDisplay(), ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("/icons/full/obj16/field_public_obj.gif"));
        final Image newTitleImage = new Image((Device)this.getShell().getDisplay(), ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("/icons/full/wizban/fieldrefact_wiz.png"));
        this.setTitleImage(newTitleImage);
        composite.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                packageImage.dispose();
                classImage.dispose();
                featureImage.dispose();
                newTitleImage.dispose();
            }
        });
        Composite container = new Composite(composite, 0);
        container.setLayoutData((Object)new GridData(1808));
        container.setLayout((Layout)new GridLayout(2, false));
        Label l = new Label(container, 0);
        l.setText(Messages.FeatureSelectionDialog_Filter);
        final Text searchText = new Text(container, 2688);
        searchText.setLayoutData((Object)new GridData(768));
        new Label(container, 0);
        this.viewer = new TreeViewer(container);
        GridData gd = new GridData(1808);
        gd.heightHint = 200;
        this.viewer.getControl().setLayoutData((Object)gd);
        this.viewer.setContentProvider((IContentProvider)new ContentProviderImpl());
        this.viewer.setLabelProvider((IBaseLabelProvider)new LabelProviderImpl(packageImage, classImage, featureImage));
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                FeatureSelectionDialog.this.okPressed();
            }
        });
        this.viewer.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                if (e1.getClass() == Util.InternalPackage.class) {
                    return ((Util.InternalPackage)e1).ePackage.getNsURI().compareTo(((Util.InternalPackage)e2).ePackage.getNsURI());
                }
                if (e1.getClass() == Util.InternalClass.class) {
                    return ((Util.InternalClass)e1).eClass.getName().compareTo(((Util.InternalClass)e2).eClass.getName());
                }
                if (e1.getClass() == Util.InternalFeature.class) {
                    return ((Util.InternalFeature)e1).feature.getName().compareTo(((Util.InternalFeature)e2).feature.getName());
                }
                return super.compare(viewer, e1, e2);
            }
        });
        final ViewerFilterImpl filter = new ViewerFilterImpl();
        this.viewer.addFilter((ViewerFilter)filter);
        searchText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                filter.setPattern(searchText.getText());
                FeatureSelectionDialog.this.viewer.refresh();
            }
        });
        this.viewer.setInput(Util.loadPackages());
        return composite;
    }

    protected void okPressed() {
        IStructuredSelection sel = (IStructuredSelection)this.viewer.getSelection();
        if (!sel.isEmpty() && sel.getFirstElement().getClass() == Util.InternalFeature.class) {
            Util.InternalFeature f = (Util.InternalFeature)sel.getFirstElement();
            Command cmd = SetCommand.create((EditingDomain)this.editingDomain, (Object)this.fragment, (Object)FragmentPackageImpl.Literals.STRING_MODEL_FRAGMENT__FEATURENAME, (Object)f.feature.getName());
            if (cmd.canExecute()) {
                this.editingDomain.getCommandStack().execute(cmd);
                super.okPressed();
            }
        }
    }

    static class ContentProviderImpl
    implements ITreeContentProvider {
        ContentProviderImpl() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            return ((List)inputElement).toArray();
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement.getClass() == Util.InternalPackage.class) {
                return ((Util.InternalPackage)parentElement).classes.toArray();
            }
            if (parentElement.getClass() == Util.InternalClass.class) {
                return ((Util.InternalClass)parentElement).features.toArray();
            }
            return new Object[0];
        }

        public Object getParent(Object element) {
            if (element.getClass() == Util.InternalFeature.class) {
                return ((Util.InternalFeature)element).clazz;
            }
            if (element.getClass() == Util.InternalClass.class) {
                return ((Util.InternalClass)element).pack;
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            return this.getChildren(element).length > 0;
        }
    }

    static class LabelProviderImpl
    extends StyledCellLabelProvider
    implements ILabelProvider {
        private final Image packageImage;
        private final Image classImage;
        private final Image featureImage;

        public LabelProviderImpl(Image packageImage, Image classImage, Image featureImage) {
            this.packageImage = packageImage;
            this.classImage = classImage;
            this.featureImage = featureImage;
        }

        public void update(ViewerCell cell) {
            if (cell.getElement().getClass() == Util.InternalPackage.class) {
                Util.InternalPackage o = (Util.InternalPackage)cell.getElement();
                StyledString styledString = new StyledString(o.ePackage.getName());
                styledString.append(" - " + o.ePackage.getNsURI(), StyledString.DECORATIONS_STYLER);
                cell.setText(styledString.getString());
                cell.setStyleRanges(styledString.getStyleRanges());
                cell.setImage(this.packageImage);
            } else if (cell.getElement().getClass() == Util.InternalClass.class) {
                Util.InternalClass o = (Util.InternalClass)cell.getElement();
                cell.setText(o.eClass.getName());
                cell.setImage(this.classImage);
            } else {
                Util.InternalFeature o = (Util.InternalFeature)cell.getElement();
                StyledString styledString = new StyledString(o.feature.getName());
                EClassifier type = ModelUtils.getTypeArgument((EClass)o.clazz.eClass, (EGenericType)o.feature.getEGenericType());
                if (o.feature.isMany()) {
                    styledString.append(" : List<" + type.getName() + ">", StyledString.DECORATIONS_STYLER);
                } else {
                    styledString.append(" : " + type.getName(), StyledString.DECORATIONS_STYLER);
                }
                cell.setText(styledString.getString());
                cell.setStyleRanges(styledString.getStyleRanges());
                cell.setImage(this.featureImage);
            }
        }

        public Image getImage(Object element) {
            return null;
        }

        public String getText(Object element) {
            if (element.getClass() == Util.InternalPackage.class) {
                Util.InternalPackage o = (Util.InternalPackage)element;
                return o.ePackage.getName();
            }
            if (element.getClass() == Util.InternalClass.class) {
                Util.InternalClass o = (Util.InternalClass)element;
                return o.eClass.getName();
            }
            Util.InternalFeature o = (Util.InternalFeature)element;
            return o.feature.getName();
        }
    }

    static class ViewerFilterImpl
    extends ViewerFilter {
        private StringMatcher matcher;

        ViewerFilterImpl() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (element.getClass() == Util.InternalPackage.class) {
                ILabelProvider pv = (ILabelProvider)((StructuredViewer)viewer).getLabelProvider();
                for (Util.InternalClass c : ((Util.InternalPackage)element).classes) {
                    if (!this.match(pv.getText((Object)c))) continue;
                    return true;
                }
                return false;
            }
            if (element.getClass() == Util.InternalPackage.class) {
                ILabelProvider pv = (ILabelProvider)((StructuredViewer)viewer).getLabelProvider();
                return this.match(pv.getText(element));
            }
            return true;
        }

        protected boolean wordMatches(String text) {
            if (text == null) {
                return false;
            }
            if (this.match(text)) {
                return true;
            }
            String[] words = this.getWords(text);
            int i = 0;
            while (i < words.length) {
                String word = words[i];
                if (this.match(word)) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        private boolean match(String string) {
            if (this.matcher == null) {
                return true;
            }
            return this.matcher.match(string);
        }

        public void setPattern(String patternString) {
            if (patternString == null || patternString.equals("")) {
                this.matcher = null;
            } else {
                String pattern = String.valueOf(patternString) + "*";
                this.matcher = new StringMatcher(pattern, true, false);
            }
        }

        private String[] getWords(String text) {
            ArrayList<String> words = new ArrayList<String>();
            BreakIterator iter = BreakIterator.getWordInstance();
            iter.setText(text);
            int i = iter.first();
            while (i != -1 && i < text.length()) {
                int j = iter.following(i);
                if (j == -1) {
                    j = text.length();
                }
                if (Character.isLetterOrDigit(text.charAt(i))) {
                    String word = text.substring(i, j);
                    words.add(word);
                }
                i = j;
            }
            return words.toArray(new String[words.size()]);
        }
    }
}

