/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.tests.css.swt;

import junit.framework.TestCase;
import org.eclipse.e4.ui.css.swt.helpers.PropertyHelper;

public class TestPropertyHelper
extends TestCase {
    public void testReadWriteProperty() {
        Impl bean = new Impl();
        try {
            TestPropertyHelper.assertEquals((Object)"A", (Object)PropertyHelper.getProperty((Object)bean, (String)"a"));
            TestPropertyHelper.assertEquals((Object)"B", (Object)PropertyHelper.getProperty((Object)bean, (String)"b"));
        }
        catch (Exception e) {
            e.printStackTrace();
            TestPropertyHelper.fail();
        }
    }

    public void testReadOnlyProperty() {
        Impl bean = new Impl();
        try {
            TestPropertyHelper.assertEquals((Object)"C", (Object)PropertyHelper.getProperty((Object)bean, (String)"c"));
            TestPropertyHelper.assertEquals((Object)true, (Object)PropertyHelper.getProperty((Object)bean, (String)"d"));
        }
        catch (Exception e) {
            e.printStackTrace();
            TestPropertyHelper.fail();
        }
    }

    public void testNestedProperty() {
        Impl bean = new Impl();
        try {
            TestPropertyHelper.assertEquals((Object)"Nested", (Object)PropertyHelper.getProperty((Object)bean, (String)"nested.a"));
        }
        catch (Exception e) {
            e.printStackTrace();
            TestPropertyHelper.fail();
        }
    }

    public static class Base {
        private String a = "A";

        public String getA() {
            return this.a;
        }

        public void setA(String a) {
            this.a = a;
        }

        public String getC() {
            return "C";
        }

        public boolean isD() {
            return true;
        }
    }

    public static class Impl
    extends Base {
        private String b = "B";
        private Base nested = new Base();

        public Impl() {
            this.nested.a = "Nested";
        }

        public String getB() {
            return this.b;
        }

        public void setB(String b) {
            this.b = b;
        }

        public Base getNested() {
            return this.nested;
        }

        public void setNested(Base nested) {
            this.nested = nested;
        }
    }
}

