/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.tests.application;

import java.util.List;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.IDisposable;
import org.eclipse.e4.core.services.contributions.IContributionFactory;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.internal.workbench.Activator;
import org.eclipse.e4.ui.model.application.MApplicationElement;
import org.eclipse.e4.ui.model.application.MContribution;
import org.eclipse.e4.ui.model.application.ui.MContext;
import org.eclipse.e4.ui.model.application.ui.MElementContainer;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspective;
import org.eclipse.e4.ui.model.application.ui.advanced.MPlaceholder;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.model.application.ui.basic.MStackElement;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.workbench.IPresentationEngine;
import org.eclipse.e4.ui.workbench.UIEvents;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HeadlessContextPresentationEngine
implements IPresentationEngine {
    @Inject
    private IEventBroker eventBroker;
    @Inject
    private IContributionFactory contributionFactory;
    private EventHandler childHandler;
    private EventHandler activeChildHandler;
    private EventHandler toBeRenderedHandler;
    private boolean createContributions = true;

    protected IEclipseContext getParentContext(MUIElement element) {
        MElementContainer parent = element.getParent();
        IEclipseContext context = null;
        while (parent != null) {
            if (parent instanceof MContext) {
                return ((MContext)parent).getContext();
            }
            parent = parent.getParent();
        }
        return context;
    }

    private static void populateModelInterfaces(MContext contextModel, IEclipseContext context, Class<?>[] interfaces) {
        Class<?>[] classArray = interfaces;
        int n = interfaces.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> intf = classArray[n2];
            Activator.trace((String)"/trace/eclipse.context", (String)("Adding " + intf.getName() + " for " + contextModel.getClass().getName()), null);
            context.set(intf.getName(), (Object)contextModel);
            HeadlessContextPresentationEngine.populateModelInterfaces(contextModel, context, intf.getInterfaces());
            ++n2;
        }
    }

    @PostConstruct
    void postConstruct() {
        this.childHandler = new EventHandler(){

            public void handleEvent(Event event) {
                Object element;
                if ("ADD".equals(event.getProperty("EventType")) && (element = event.getProperty("NewValue")) instanceof MUIElement) {
                    MPartStack stack;
                    List children;
                    Object parent = event.getProperty("ChangedElement");
                    HeadlessContextPresentationEngine.this.createGui((MUIElement)element, parent, HeadlessContextPresentationEngine.this.getParentContext((MUIElement)element));
                    if (parent instanceof MPartStack && (children = (stack = (MPartStack)parent).getChildren()).size() == 1) {
                        stack.setSelectedElement((MUIElement)((MPart)element));
                    }
                }
            }
        };
        this.eventBroker.subscribe(UIEvents.buildTopic((String)"org/eclipse/e4/ui/model/ui/ElementContainer", (String)"children"), this.childHandler);
        this.activeChildHandler = new EventHandler(){

            public void handleEvent(Event event) {
                Object element = event.getProperty("NewValue");
                if (element instanceof MUIElement) {
                    Object parent = event.getProperty("ChangedElement");
                    HeadlessContextPresentationEngine.this.createGui((MUIElement)element, parent, HeadlessContextPresentationEngine.this.getParentContext((MUIElement)element));
                }
            }
        };
        this.eventBroker.subscribe(UIEvents.buildTopic((String)"org/eclipse/e4/ui/model/ui/ElementContainer", (String)"selectedElement"), this.activeChildHandler);
        this.toBeRenderedHandler = new EventHandler(){

            public void handleEvent(Event event) {
                MUIElement element = (MUIElement)event.getProperty("ChangedElement");
                Boolean value = (Boolean)event.getProperty("NewValue");
                if (value.booleanValue()) {
                    HeadlessContextPresentationEngine.this.createGui(element, element.getParent(), HeadlessContextPresentationEngine.this.getParentContext(element));
                } else {
                    HeadlessContextPresentationEngine.this.removeGui(element);
                }
            }
        };
        this.eventBroker.subscribe(UIEvents.buildTopic((String)"org/eclipse/e4/ui/model/ui/UIElement", (String)"toBeRendered"), this.toBeRenderedHandler);
    }

    public void setCreateContributions(boolean createContributions) {
        this.createContributions = createContributions;
    }

    public Object createGui(MUIElement element, Object parentWidget, IEclipseContext parentContext) {
        MPlaceholder placeholder;
        MUIElement ref;
        if (!element.isToBeRendered()) {
            return null;
        }
        if (element instanceof MContext) {
            MContribution contribution;
            String uri;
            MContext mcontext = (MContext)element;
            if (mcontext.getContext() != null) {
                return null;
            }
            String contextName = String.valueOf(element.getClass().getInterfaces()[0].getName()) + " eclipse context";
            IEclipseContext createdContext = parentContext != null ? parentContext.createChild(contextName) : EclipseContextFactory.create((String)contextName);
            HeadlessContextPresentationEngine.populateModelInterfaces(mcontext, createdContext, element.getClass().getInterfaces());
            for (String variable : mcontext.getVariables()) {
                createdContext.declareModifiable(variable);
            }
            mcontext.setContext(createdContext);
            if (element instanceof MContribution && this.createContributions && (uri = (contribution = (MContribution)element).getContributionURI()) != null) {
                Object clientObject = this.contributionFactory.create(uri, createdContext);
                contribution.setObject(clientObject);
            }
            if (parentContext != null && parentContext.getLocal("activeChildContext") == null) {
                parentContext.set("activeChildContext", (Object)createdContext);
            }
        }
        if (element instanceof MPartStack) {
            MPartStack container = (MPartStack)element;
            MPart active = (MPart)container.getSelectedElement();
            if (active != null) {
                this.createGui((MUIElement)active, container, this.getParentContext((MUIElement)active));
            } else {
                List children = container.getChildren();
                if (!children.isEmpty()) {
                    container.setSelectedElement((MUIElement)((MStackElement)children.get(0)));
                }
            }
        } else if (element instanceof MElementContainer) {
            for (Object child : ((MElementContainer)element).getChildren()) {
                if (!(child instanceof MUIElement)) continue;
                this.createGui((MUIElement)child, element, this.getParentContext((MUIElement)child));
                if (!(child instanceof MContext)) continue;
                IEclipseContext childContext = ((MContext)child).getContext();
                IEclipseContext pContext = this.getParentContext((MUIElement)child);
                if (pContext.getLocal("activeChildContext") != null) continue;
                pContext.set("activeChildContext", (Object)childContext);
            }
            if (element instanceof MWindow) {
                MWindow window = (MWindow)element;
                for (MWindow childWindow : window.getWindows()) {
                    this.createGui((MUIElement)childWindow, element, window.getContext());
                }
            }
            if (element instanceof MPerspective) {
                MPerspective perspective = (MPerspective)element;
                for (MWindow childWindow : perspective.getWindows()) {
                    this.createGui((MUIElement)childWindow, element, perspective.getContext());
                }
            }
        } else if (element instanceof MPlaceholder && (ref = (placeholder = (MPlaceholder)element).getRef()) != null) {
            this.createGui(ref);
            ref.setCurSharedRef(placeholder);
        }
        return null;
    }

    public Object createGui(MUIElement element) {
        return this.createGui(element, null, this.getParentContext(element));
    }

    public void removeGui(MUIElement element) {
        if (element instanceof MElementContainer) {
            for (Object child : ((MElementContainer)element).getChildren()) {
                if (!(child instanceof MUIElement)) continue;
                this.removeGui((MUIElement)child);
            }
        }
        if (element instanceof MContext) {
            MContext mcontext = (MContext)element;
            IEclipseContext context = mcontext.getContext();
            mcontext.setContext(null);
            if (context instanceof IDisposable) {
                context.dispose();
            }
        }
    }

    public Object run(MApplicationElement uiRoot, IEclipseContext appContext) {
        return 0;
    }

    public void stop() {
    }
}

