/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.tests.workbench;

import javax.inject.Inject;
import javax.inject.Named;
import junit.framework.TestCase;
import org.eclipse.e4.core.contexts.ContextFunction;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.IDisposable;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.internal.workbench.E4Workbench;
import org.eclipse.e4.ui.internal.workbench.swt.E4Application;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.MApplicationElement;
import org.eclipse.e4.ui.model.application.impl.ApplicationFactoryImpl;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspective;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspectiveStack;
import org.eclipse.e4.ui.model.application.ui.advanced.impl.AdvancedFactoryImpl;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.model.application.ui.basic.impl.BasicFactoryImpl;

public class Bug318460Test
extends TestCase {
    protected IEclipseContext appContext;
    protected E4Workbench wb;

    protected void setUp() throws Exception {
        this.appContext = E4Application.createDefaultContext();
        this.appContext.set("presentationURI", (Object)"platform:/plugin/org.eclipse.e4.ui.workbench.swt/org.eclipse.e4.ui.internal.workbench.swt.PartRenderingEngine");
    }

    protected void tearDown() throws Exception {
        if (this.wb != null) {
            this.wb.close();
        }
        if (this.appContext instanceof IDisposable) {
            this.appContext.dispose();
        }
    }

    public void testBug318460_A() {
        IEclipseContext context = EclipseContextFactory.create();
        context.set("partServiceRoot", (Object)new ContextFunction(){

            public Object compute(IEclipseContext context) {
                IEclipseContext child = (IEclipseContext)context.getLocal("activeChildContext");
                while (child != null) {
                    context = child;
                    child = (IEclipseContext)context.getLocal("activeChildContext");
                }
                return context;
            }
        });
        RootContainerConsumer consumer = (RootContainerConsumer)ContextInjectionFactory.make(RootContainerConsumer.class, (IEclipseContext)context);
        Object o = ContextInjectionFactory.make(Object.class, (IEclipseContext)context);
        IEclipseContext childContextA = context.createChild();
        IEclipseContext childContextB = context.createChild();
        context.set("activeChildContext", (Object)childContextA);
        Bug318460Test.assertEquals((Object)childContextA, (Object)consumer.root);
        context.set("activeChildContext", (Object)childContextB);
        Bug318460Test.assertEquals((Object)childContextB, (Object)consumer.root);
        ContextInjectionFactory.uninject((Object)o, (IEclipseContext)context);
        context.set("activeChildContext", (Object)childContextA);
        Bug318460Test.assertEquals((Object)childContextA, (Object)consumer.root);
    }

    public void testBug318460_B() {
        MApplication application = ApplicationFactoryImpl.eINSTANCE.createApplication();
        MWindow window = BasicFactoryImpl.eINSTANCE.createWindow();
        application.getChildren().add(window);
        application.setSelectedElement((MUIElement)window);
        MPerspectiveStack perspectiveStack = AdvancedFactoryImpl.eINSTANCE.createPerspectiveStack();
        window.getChildren().add(perspectiveStack);
        window.setSelectedElement((MUIElement)perspectiveStack);
        application.setContext(this.appContext);
        this.appContext.set(MApplication.class.getName(), (Object)application);
        this.wb = new E4Workbench((MApplicationElement)application, this.appContext);
        this.wb.createAndRunUI((MApplicationElement)window);
        RootContainerConsumer consumer = (RootContainerConsumer)ContextInjectionFactory.make(RootContainerConsumer.class, (IEclipseContext)window.getContext());
        Object o = ContextInjectionFactory.make(Object.class, (IEclipseContext)window.getContext());
        MPerspective perspectiveA = AdvancedFactoryImpl.eINSTANCE.createPerspective();
        perspectiveStack.getChildren().add(perspectiveA);
        perspectiveStack.setSelectedElement((MUIElement)perspectiveA);
        Bug318460Test.assertEquals((Object)perspectiveA, (Object)consumer.root);
        MPerspective perspectiveB = AdvancedFactoryImpl.eINSTANCE.createPerspective();
        perspectiveStack.getChildren().add(perspectiveB);
        perspectiveStack.setSelectedElement((MUIElement)perspectiveB);
        Bug318460Test.assertEquals((Object)perspectiveB, (Object)consumer.root);
        ContextInjectionFactory.uninject((Object)o, (IEclipseContext)window.getContext());
        perspectiveStack.setSelectedElement((MUIElement)perspectiveA);
        Bug318460Test.assertEquals((Object)perspectiveA, (Object)consumer.root);
    }

    static class RootContainerConsumer {
        Object root;

        RootContainerConsumer() {
        }

        @Inject
        void inject(@Named(value="partServiceRoot") @Optional Object root) {
            this.root = root;
        }
    }
}

