/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.workbench.renderers.swt.cocoa;

import javax.inject.Inject;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.commands.MBindingTable;
import org.eclipse.e4.ui.model.application.commands.MCommand;
import org.eclipse.e4.ui.model.application.commands.MHandler;
import org.eclipse.e4.ui.model.application.commands.MKeyBinding;
import org.eclipse.e4.ui.model.application.commands.impl.CommandsFactoryImpl;
import org.eclipse.e4.ui.workbench.renderers.swt.cocoa.CloseDialogHandler;
import org.eclipse.e4.ui.workbench.renderers.swt.cocoa.CocoaUIHandler;

public class CocoaUIProcessor {
    private static final String HOST_ID = "org.eclipse.e4.ui.workbench.renderers.swt";
    private final String CLOSE_DIALOG_COMMAND = "org.eclipse.ui.cocoa.closeDialog";
    private static final String DIALOG_CONTEXT_ID = "org.eclipse.ui.contexts.dialog";
    private static final String CLOSE_DIALOG_KEYSEQUENCE = "M1+W";
    @Inject
    protected MApplication app;
    @Inject
    protected IEclipseContext context;
    protected MCommand closeDialogCommand;

    @Execute
    public void execute() {
        IEclipseContext ctxt = this.context.getParent().createChild(CocoaUIHandler.class.getName());
        CocoaUIHandler uiHandler = (CocoaUIHandler)ContextInjectionFactory.make(CocoaUIHandler.class, (IEclipseContext)ctxt);
        ContextInjectionFactory.invoke((Object)uiHandler, Execute.class, (IEclipseContext)ctxt);
        this.addCloseDialogCommand();
        this.addCloseDialogHandler();
        this.addCloseDialogBinding();
    }

    private void addCloseDialogCommand() {
        for (MCommand cmd : this.app.getCommands()) {
            if (cmd.getElementId() == null || !"org.eclipse.ui.cocoa.closeDialog".equals(cmd.getElementId())) continue;
            this.closeDialogCommand = cmd;
            return;
        }
        this.closeDialogCommand = CommandsFactoryImpl.eINSTANCE.createCommand();
        this.closeDialogCommand.setElementId("org.eclipse.ui.cocoa.closeDialog");
        this.closeDialogCommand.setCommandName("org.eclipse.ui.cocoa.closeDialog");
        this.app.getCommands().add(this.closeDialogCommand);
    }

    private void addCloseDialogHandler() {
        MHandler handler2;
        for (MHandler handler2 : this.app.getHandlers()) {
            if (handler2.getCommand() != this.closeDialogCommand) continue;
            return;
        }
        handler2 = CommandsFactoryImpl.eINSTANCE.createHandler();
        handler2.setCommand(this.closeDialogCommand);
        handler2.setContributionURI("platform:/plugin/org.eclipse.e4.ui.workbench.renderers.swt/" + CloseDialogHandler.class.getName());
        this.app.getHandlers().add(handler2);
    }

    private void addCloseDialogBinding() {
        MKeyBinding kb2;
        MBindingTable bt = this.findBindingTable(DIALOG_CONTEXT_ID);
        for (MKeyBinding kb2 : bt.getBindings()) {
            if (kb2.getCommand() != this.closeDialogCommand) continue;
            return;
        }
        kb2 = CommandsFactoryImpl.eINSTANCE.createKeyBinding();
        kb2.setCommand(this.closeDialogCommand);
        kb2.setKeySequence(CLOSE_DIALOG_KEYSEQUENCE);
        bt.getBindings().add(kb2);
    }

    private MBindingTable findBindingTable(String contextId) {
        MBindingTable bt2;
        for (MBindingTable bt2 : this.app.getBindingTables()) {
            if (bt2.getBindingContextId() == null || !bt2.getBindingContextId().equals(contextId)) continue;
            return bt2;
        }
        bt2 = CommandsFactoryImpl.eINSTANCE.createBindingTable();
        bt2.setBindingContextId(contextId);
        this.app.getBindingTables().add(bt2);
        return bt2;
    }
}

