/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.xwt.tools.ui.designer.core.editor;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.e4.xwt.tools.ui.designer.core.editor.ISelectionSynchronizer;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;

public class SelectionSynchronizer
implements ISelectionChangedListener,
ISelectionSynchronizer {
    private List<ISelectionProvider> providers = new ArrayList<ISelectionProvider>();
    private boolean isDispatching = false;
    private int disabled = 0;
    private ISelectionProvider pendingSelection;

    public void addProvider(ISelectionProvider provider) {
        provider.addSelectionChangedListener((ISelectionChangedListener)this);
        this.providers.add(provider);
    }

    protected EditPart convert(ISelectionProvider provider, EditPart part) {
        if (provider instanceof EditPartViewer) {
            return (EditPart)((EditPartViewer)provider).getEditPartRegistry().get(part.getModel());
        }
        return part;
    }

    public void removeProvider(ISelectionProvider viewer) {
        viewer.removeSelectionChangedListener((ISelectionChangedListener)this);
        this.providers.remove(viewer);
        if (this.pendingSelection == viewer) {
            this.pendingSelection = null;
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        if (this.isDispatching) {
            return;
        }
        ISelectionProvider source = event.getSelectionProvider();
        if (this.disabled > 0) {
            this.pendingSelection = source;
        } else {
            ISelection selection = event.getSelection();
            this.syncSelection(source, selection);
        }
    }

    private void syncSelection(ISelectionProvider source, ISelection selection) {
        this.isDispatching = true;
        int i = 0;
        while (i < this.providers.size()) {
            if (this.providers.get(i) != source) {
                ISelectionProvider viewer = this.providers.get(i);
                this.setViewerSelection(source, viewer, selection);
            }
            ++i;
        }
        this.isDispatching = false;
    }

    public void setEnabled(boolean value) {
        if (!value) {
            ++this.disabled;
        } else if (--this.disabled == 0 && this.pendingSelection != null) {
            this.syncSelection(this.pendingSelection, this.pendingSelection.getSelection());
            this.pendingSelection = null;
        }
    }

    protected void setViewerSelection(ISelectionProvider source, ISelectionProvider viewer, ISelection selection) {
        ArrayList<EditPart> result = new ArrayList<EditPart>();
        Iterator iter = ((IStructuredSelection)selection).iterator();
        while (iter.hasNext()) {
            EditPart part = this.convert(viewer, (EditPart)iter.next());
            if (part == null) continue;
            result.add(part);
        }
        viewer.setSelection((ISelection)new StructuredSelection(result));
        if (result.size() > 0 && viewer instanceof EditPartViewer) {
            ((EditPartViewer)viewer).reveal((EditPart)result.get(result.size() - 1));
        }
    }
}

