/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.xwt.tools.ui.designer.core.figures;

import org.eclipse.draw2d.AbstractBorder;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.Color;

public class OutlineBorder
extends AbstractBorder {
    protected Color foreground = ColorConstants.black;
    protected Color background;
    private int alpha = 255;
    private boolean borderDisabled;
    private boolean overrideAndDisable;
    private static final Insets insets = new Insets(0, 0, 0, 0);
    protected int lineStyle = 1;

    public OutlineBorder() {
    }

    public OutlineBorder(Color foreground, Color background) {
        this.foreground = foreground;
        this.background = background;
    }

    public OutlineBorder(int alpha, Color foreground, Color background) {
        this(foreground, background);
        this.setAlpha(alpha);
    }

    public OutlineBorder(Color foreground, Color background, int lineStyle) {
        this(foreground, background);
        this.lineStyle = lineStyle;
    }

    public OutlineBorder(int alpha, Color foreground, Color background, int lineStyle) {
        this(alpha, foreground, background);
        this.lineStyle = lineStyle;
    }

    public void paint(IFigure aFigure, Graphics g, Insets insets) {
        if (this.overrideAndDisable || this.borderDisabled) {
            return;
        }
        Rectangle r = OutlineBorder.getPaintRectangle((IFigure)aFigure, (Insets)insets);
        r.resize(-1, -1);
        try {
            g.setAlpha(this.getAlpha());
        }
        catch (SWTException sWTException) {}
        g.setForegroundColor(this.foreground);
        if (this.lineStyle != 1) {
            if (this.background != null) {
                g.setBackgroundColor(this.background);
            } else {
                g.setBackgroundColor(ColorConstants.black);
                g.setXORMode(true);
            }
        }
        g.setLineStyle(this.lineStyle);
        g.drawRectangle(r);
    }

    public void setColors(Color foreground, Color background) {
        this.foreground = foreground;
        this.background = background;
    }

    public void setLineStyle(int aStyle) {
        this.lineStyle = aStyle;
    }

    public Insets getInsets(IFigure aFigure) {
        return insets;
    }

    public boolean isOpaque() {
        return true;
    }

    public void setBorderDisabled(boolean borderDisabled) {
        this.borderDisabled = borderDisabled;
    }

    public boolean isBorderDisabled() {
        return this.borderDisabled;
    }

    public void setOverrideAndDisable(boolean overrideAndDisable) {
        this.overrideAndDisable = overrideAndDisable;
    }

    public boolean isOverrideAndDisable() {
        return this.overrideAndDisable;
    }

    public void setAlpha(int alpha) {
        this.alpha = alpha;
    }

    public int getAlpha() {
        return this.alpha;
    }
}

