/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.xwt.tools.ui.designer.commands;

import org.eclipse.e4.xwt.internal.core.ScopeKeeper;
import org.eclipse.e4.xwt.internal.utils.UserData;
import org.eclipse.e4.xwt.tools.ui.designer.loader.XWTProxy;
import org.eclipse.e4.xwt.tools.ui.xaml.XamlAttribute;
import org.eclipse.e4.xwt.tools.ui.xaml.XamlFactory;
import org.eclipse.e4.xwt.tools.ui.xaml.XamlNode;
import org.eclipse.gef.commands.Command;
import org.eclipse.swt.widgets.Widget;

public class NamedCommand
extends Command {
    private XamlNode node;
    private String newName;
    private String oldName;
    private XamlAttribute nameAttr;

    public NamedCommand(XamlNode node, String newName) {
        this.node = node;
        if (newName != null) {
            this.newName = newName;
        }
    }

    public NamedCommand(Widget widget, String newName) {
        this(XWTProxy.getModel(widget), newName);
        if (newName == null) {
            this.newName = NamedCommand.generateName(widget);
        }
    }

    public NamedCommand(Widget widget) {
        this(widget, null);
    }

    public boolean canExecute() {
        if (this.node == null || this.newName == null) {
            return false;
        }
        this.nameAttr = this.node.getAttribute("name");
        if (this.nameAttr == null) {
            this.nameAttr = this.node.getAttribute("name", "http://www.eclipse.org/xwt");
        }
        return this.nameAttr == null || !this.newName.equals(this.nameAttr.getValue());
    }

    public void execute() {
        if (this.nameAttr == null) {
            this.nameAttr = XamlFactory.eINSTANCE.createAttribute("name", "http://www.eclipse.org/xwt/presentation");
        }
        this.oldName = this.nameAttr.getValue();
        this.nameAttr.setValue(this.newName);
        if (!this.node.getAttributes().contains((Object)this.nameAttr)) {
            this.node.getAttributes().add((Object)this.nameAttr);
        }
    }

    public void undo() {
        if (this.oldName == null) {
            this.node.getAttributes().remove((Object)this.nameAttr);
        } else {
            this.nameAttr.setValue(this.oldName);
        }
    }

    public boolean canUndo() {
        return this.node != null && this.nameAttr != null;
    }

    public static String generateName(Widget widget) {
        String typeName = widget.getClass().getSimpleName();
        typeName = typeName.length() > 1 ? String.valueOf(Character.toLowerCase(typeName.charAt(0))) + typeName.substring(1) : typeName.toLowerCase();
        ScopeKeeper nameContext = UserData.findScopeKeeper((Object)widget);
        if (nameContext != null) {
            String name = null;
            int i = 0;
            while (i < Integer.MAX_VALUE) {
                name = String.valueOf(typeName) + i;
                if (!nameContext.containsName(name)) break;
                ++i;
            }
            return name;
        }
        return String.valueOf(typeName) + "0";
    }
}

