/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.xwt.tools.ui.designer.databinding.ui;

import org.eclipse.e4.xwt.tools.ui.designer.databinding.BindingContext;
import org.eclipse.e4.xwt.tools.ui.designer.databinding.IObservable;
import org.eclipse.e4.xwt.tools.ui.designer.resources.ImageShop;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;

public class ObservableList {
    protected TreeViewer treeViewer;
    protected ViewerFilter viewerFilter;
    protected String filter;
    private BindingContext bindingContext;
    private Control control;

    public ObservableList(BindingContext bindingContext, Composite parent) {
        this.bindingContext = bindingContext;
        this.control = this.createControl(parent);
    }

    public Control getControl() {
        return this.control;
    }

    protected Control createControl(Composite parent) {
        Composite control = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        control.setLayout((Layout)layout);
        Label label = new Label(control, 0);
        label.setText("Widgets:");
        label.setLayoutData((Object)new GridData(768));
        this.treeViewer = this.createControlsViewer(control);
        this.treeViewer.getTree().setLayoutData((Object)new GridData(1808));
        this.viewerFilter = this.createControlsFilter();
        return control;
    }

    public TreeViewer getTreeViewer() {
        return this.treeViewer;
    }

    protected TreeViewer createControlsViewer(Composite control) {
        TreeViewer treeViewer = new TreeViewer(control, 2816);
        GridData layoutData = new GridData(1808);
        treeViewer.getTree().setLayoutData((Object)layoutData);
        treeViewer.setContentProvider((IContentProvider)new ITreeContentProvider(){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                if (inputElement instanceof IObservable[]) {
                    return (IObservable[])inputElement;
                }
                return new Object[0];
            }

            public boolean hasChildren(Object element) {
                if (element instanceof IObservable) {
                    return ((IObservable)element).hasChildren();
                }
                return false;
            }

            public Object getParent(Object element) {
                if (element instanceof IObservable) {
                    return ((IObservable)element).getParent();
                }
                return null;
            }

            public Object[] getChildren(Object parentElement) {
                if (parentElement instanceof IObservable) {
                    return ((IObservable)parentElement).getChildren();
                }
                return null;
            }
        });
        treeViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof IObservable) {
                    return ((IObservable)element).getDisplayName();
                }
                return super.getText(element);
            }

            public Image getImage(Object element) {
                if (element instanceof IObservable) {
                    Object source = ((IObservable)element).getSource();
                    if (source == null) {
                        return super.getImage(element);
                    }
                    if (source instanceof Widget) {
                        return ImageShop.getImageForWidget((Widget)source);
                    }
                    if (source instanceof Viewer) {
                        return ImageShop.getObj16(((Viewer)source).getClass().getSimpleName().toLowerCase());
                    }
                    return ImageShop.getImageForType(source.getClass());
                }
                return super.getImage(element);
            }
        });
        treeViewer.setAutoExpandLevel(3);
        treeViewer.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (element instanceof IObservable) {
                    return ((IObservable)element).getProperties().length > 0;
                }
                return false;
            }
        });
        return treeViewer;
    }

    protected ViewerFilter createControlsFilter() {
        return new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                return ObservableList.this.isFiltered(element);
            }
        };
    }

    protected boolean isFiltered(Object element) {
        ITreeContentProvider contentProvider = (ITreeContentProvider)this.treeViewer.getContentProvider();
        Object[] children = contentProvider.getChildren(element);
        ILabelProvider labelProvider = (ILabelProvider)this.treeViewer.getLabelProvider();
        String text = labelProvider.getText(element);
        boolean filtered = text.toLowerCase().startsWith(this.filter.toLowerCase());
        if (!filtered) {
            Object[] objectArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                Object child = objectArray[n2];
                filtered = this.isFiltered(child);
                if (filtered) break;
                ++n2;
            }
        }
        return filtered;
    }

    protected void controlSelected() {
        IStructuredSelection selection = (IStructuredSelection)this.treeViewer.getSelection();
        Object firstElement = selection.getFirstElement();
        this.bindingContext.setTarget((IObservable)firstElement);
    }

    public void applyFilter(String filter) {
        this.filter = filter;
        if (filter == null || filter.length() == 0) {
            this.treeViewer.removeFilter(this.viewerFilter);
        } else {
            this.treeViewer.addFilter(this.viewerFilter);
        }
    }

    public void setInput(Object input) {
        if (this.treeViewer != null) {
            this.treeViewer.setInput(input);
        }
    }
}

