/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.xwt.ui.editor.checkers;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.e4.xwt.ui.editor.checkers.AbstractProblemChecker;
import org.eclipse.e4.xwt.vex.problems.Problem;
import org.eclipse.wst.sse.ui.StructuredTextEditor;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ElementNameChecker
extends AbstractProblemChecker {
    @Override
    public List<Problem> checkProblems(StructuredTextEditor textEditor, String javaName) {
        ArrayList<Problem> problems = new ArrayList<Problem>();
        Node root = this.getRoot(textEditor);
        this.checkProblems(textEditor, root, problems, new ArrayList<String>());
        return problems;
    }

    private void checkProblems(StructuredTextEditor textEditor, Node node, List<Problem> problems, List<String> existedNames) {
        NamedNodeMap attributes;
        if (!this.isValid(node)) {
            return;
        }
        NodeList childNodes = node.getChildNodes();
        if (childNodes != null) {
            int length = childNodes.getLength();
            int i = 0;
            while (i < length) {
                Node item = childNodes.item(i);
                this.checkProblems(textEditor, item, problems, existedNames);
                ++i;
            }
        }
        if ((attributes = node.getAttributes()) == null) {
            return;
        }
        int attrLength = attributes.getLength();
        int j = 0;
        while (j < attrLength) {
            String nodeValue;
            Node attr = attributes.item(j);
            String nodeName = attr.getNodeName();
            if (nodeName != null && "x:Name".equalsIgnoreCase(nodeName) && (nodeValue = attr.getNodeValue()) != null) {
                if (existedNames.contains(nodeValue)) {
                    Problem problem = this.createProblem(textEditor, node, "Element Name \"" + nodeValue + "\" is already used.", 3);
                    problems.add(problem);
                } else {
                    existedNames.add(nodeValue);
                }
            }
            ++j;
        }
    }

    @Override
    protected void checkProblems(StructuredTextEditor textEditor, String javaName, Node node, List<Problem> problems, boolean includeChildren) {
    }
}

