/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.swt.targetvm.macosx.cocoa;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class ImageCapture
extends org.eclipse.e4.xwt.vex.swt.ImageCapture {
    static Field GC_handle;
    static Field Control_view;
    static Method NSView_superview;
    static Method NSObject_isEqual;
    static Method NSView_bounds;
    static Method NSGraphicsContext_saveGraphicsState;
    static Method NSGraphicsContext_restoreGraphicsState;
    static Method NSGraphicsContext_setCurrentContext;
    static Method NSAffineTransform_transform;
    static Method NSAffineTransform_translateXBy;
    static Method NSAffineTransform_scaleXBy;
    static Method NSAffineTransform_concat;
    static Method NSView_displayRectIgnoringOpacity;

    static {
        try {
            Control_view = Control.class.getDeclaredField("view");
            Control_view.setAccessible(true);
            GC_handle = GC.class.getDeclaredField("handle");
            GC_handle.setAccessible(true);
            Class<?> NSViewClass = Class.forName("org.eclipse.swt.internal.cocoa.NSView");
            NSView_superview = NSViewClass.getMethod("superview", new Class[0]);
            Class<?> idClass = Class.forName("org.eclipse.swt.internal.cocoa.id");
            Class<?> NSObjectClass = Class.forName("org.eclipse.swt.internal.cocoa.NSObject");
            NSObject_isEqual = NSObjectClass.getMethod("isEqual", idClass);
            NSView_bounds = NSViewClass.getMethod("bounds", new Class[0]);
            Class<?> NSGraphicsContextClass = Class.forName("org.eclipse.swt.internal.cocoa.NSGraphicsContext");
            NSGraphicsContext_saveGraphicsState = NSGraphicsContextClass.getMethod("saveGraphicsState", new Class[0]);
            NSGraphicsContext_setCurrentContext = NSGraphicsContextClass.getMethod("setCurrentContext", NSGraphicsContextClass);
            NSGraphicsContext_restoreGraphicsState = NSGraphicsContextClass.getMethod("restoreGraphicsState", new Class[0]);
            Class<?> NSAffineTransformClass = Class.forName("org.eclipse.swt.internal.cocoa.NSAffineTransform");
            NSAffineTransform_transform = NSAffineTransformClass.getMethod("transform", new Class[0]);
            NSAffineTransform_translateXBy = NSAffineTransformClass.getMethod("translateXBy", Double.TYPE, Double.TYPE);
            if (NSAffineTransform_translateXBy == null) {
                NSAffineTransform_translateXBy = NSAffineTransformClass.getMethod("translateXBy", Float.TYPE, Float.TYPE);
            }
            if ((NSAffineTransform_scaleXBy = NSAffineTransformClass.getMethod("scaleXBy", Double.TYPE, Double.TYPE)) == null) {
                NSAffineTransform_scaleXBy = NSAffineTransformClass.getMethod("scaleXBy", Float.TYPE, Float.TYPE);
            }
            NSAffineTransform_concat = NSAffineTransformClass.getMethod("concat", new Class[0]);
            Class<?> NSRectClass = Class.forName("org.eclipse.swt.internal.cocoa.NSRect");
            NSView_displayRectIgnoringOpacity = NSViewClass.getMethod("displayRectIgnoringOpacity", NSRectClass, NSGraphicsContextClass);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected Image getImage(Control control, int maxWidth, int maxHeight, boolean includeChildren) {
        Rectangle rectangle = new Rectangle(0, 0, maxWidth, maxHeight);
        Image image = new Image((Device)control.getDisplay(), rectangle);
        GC gc = new GC((Drawable)image);
        try {
            Object view = Control_view.get(control);
            if (control instanceof Shell) {
                Object superview = NSView_superview.invoke(view, new Object[0]);
                while (superview != null) {
                    view = superview;
                    superview = NSView_superview.invoke(view, new Object[0]);
                }
            } else {
                Composite parent = control.getParent();
                Object parentView = Control_view.get(parent);
                while (true) {
                    Object superview = NSView_superview.invoke(view, new Object[0]);
                    Boolean equal = (Boolean)NSObject_isEqual.invoke(superview, parentView);
                    if (equal.booleanValue()) break;
                    view = superview;
                }
            }
            Object gcHandle = GC_handle.get(gc);
            NSGraphicsContext_saveGraphicsState.invoke(gcHandle, new Object[0]);
            NSGraphicsContext_setCurrentContext.invoke(null, gcHandle);
            Object transform = NSAffineTransform_transform.invoke(null, new Object[0]);
            NSAffineTransform_translateXBy.invoke(transform, 0, rectangle.height);
            NSAffineTransform_scaleXBy.invoke(transform, 1, -1);
            NSAffineTransform_concat.invoke(transform, new Object[0]);
            Object bounds = NSView_bounds.invoke(view, new Object[0]);
            NSView_displayRectIgnoringOpacity.invoke(view, bounds, gcHandle);
            NSGraphicsContext_restoreGraphicsState.invoke(gcHandle, new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        gc.dispose();
        return image;
    }
}

