/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.xwt.core;

import java.util.HashMap;
import org.eclipse.core.databinding.observable.ChangeEvent;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.e4.xwt.XWT;
import org.eclipse.e4.xwt.core.Condition;
import org.eclipse.e4.xwt.core.IBinding;
import org.eclipse.e4.xwt.core.IDynamicBinding;
import org.eclipse.e4.xwt.core.Setter;
import org.eclipse.e4.xwt.core.SetterBase;
import org.eclipse.e4.xwt.core.TriggerBase;
import org.eclipse.e4.xwt.internal.utils.UserData;
import org.eclipse.swt.widgets.Widget;

public class MultiDataTrigger
extends TriggerBase {
    private Condition[] conditions = Condition.EMPTY_ARRAY;
    private Setter[] setters;
    private ValueChangeListener changeListener;

    public Condition[] getConditions() {
        return this.conditions;
    }

    public void setConditions(Condition[] conditions) {
        this.conditions = conditions;
    }

    public Setter[] getSetters() {
        return this.setters;
    }

    public void setSetters(Setter[] setters) {
        this.setters = setters;
    }

    public void prepare(Object target) {
        if (this.getConditions().length == 0) {
            return;
        }
        Widget widget = UserData.getWidget(target);
        if (widget == null) {
            return;
        }
        this.changeListener = new ValueChangeListener(target);
        Condition[] conditionArray = this.getConditions();
        int n = conditionArray.length;
        int n2 = 0;
        while (n2 < n) {
            Condition condition = conditionArray[n2];
            String sourceName = condition.getSourceName();
            IBinding binding = condition.getBinding();
            Object bindingTarget = null;
            if (binding != null) {
                if (binding instanceof IDynamicBinding) {
                    IDynamicBinding dynamicBinding = (IDynamicBinding)binding;
                    bindingTarget = dynamicBinding.createBoundSource();
                } else {
                    bindingTarget = binding.getValue(null);
                }
            } else {
                Object sourceObject = MultiDataTrigger.getElementByName(target, sourceName);
                Widget sourceWidget = UserData.getWidget(sourceObject);
                bindingTarget = XWT.getDataContext(sourceWidget);
            }
            if (!(bindingTarget instanceof IObservableValue)) {
                return;
            }
            IObservableValue observableValue = (IObservableValue)bindingTarget;
            observableValue.addChangeListener((IChangeListener)this.changeListener);
            ++n2;
        }
        this.changeListener.doHandleChange(false);
    }

    public void on(Object target) {
        this.changeListener.doHandleChange(true);
    }

    class ValueChangeListener
    extends TriggerBase.AbstractChangeListener {
        public ValueChangeListener(Object element) {
            super(MultiDataTrigger.this, element);
        }

        public void handleChange(ChangeEvent event) {
            this.doHandleChange(true);
        }

        public void doHandleChange(boolean update) {
            Object[] objectArray = MultiDataTrigger.this.getConditions();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Condition condition = objectArray[n2];
                if (!condition.evaluate(this.element)) {
                    this.restoreValues();
                    return;
                }
                ++n2;
            }
            objectArray = MultiDataTrigger.this.getSetters();
            n = objectArray.length;
            n2 = 0;
            while (n2 < n) {
                Object setter = objectArray[n2];
                try {
                    Object oldValue = ((SetterBase)setter).applyTo(this.element, update);
                    if (this.oldvalues == null) {
                        this.oldvalues = new HashMap();
                    }
                    this.oldvalues.put(setter, oldValue);
                }
                catch (RuntimeException runtimeException) {}
                ++n2;
            }
        }
    }
}

