/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.xwt.jface;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.e4.xwt.XWT;
import org.eclipse.e4.xwt.XWTException;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.widgets.TableItem;

public class DefaultCellModifier
implements ICellModifier {
    protected TableViewer tableViewer;

    public DefaultCellModifier(TableViewer tableViewer) {
        this.tableViewer = tableViewer;
    }

    private BeanInfo getBeanInfo(Object element) {
        try {
            return Introspector.getBeanInfo(element.getClass());
        }
        catch (IntrospectionException e) {
            e.printStackTrace();
            return null;
        }
    }

    public boolean canModify(Object element, String property) {
        return this.getDescriptor(element, property) != null;
    }

    public Object getValue(Object element, String property) {
        PropertyDescriptor descriptor = this.getDescriptor(element, property);
        if (descriptor != null) {
            try {
                return descriptor.getReadMethod().invoke(element, new Object[0]);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return "";
    }

    public void modify(Object element, String property, Object value) {
        TableItem tableItem;
        Object data;
        PropertyDescriptor descriptor;
        if (element instanceof TableItem && (descriptor = this.getDescriptor(data = (tableItem = (TableItem)element).getData(), property)) != null) {
            try {
                Class<?> type = descriptor.getPropertyType();
                IConverter converter = XWT.findConvertor(value.getClass(), type);
                if (converter == null) {
                    throw new XWTException("Converter doesn't exist from \"" + value.getClass().getName() + "\" to \"" + type.getName());
                }
                Object newValue = converter.convert(value);
                descriptor.getWriteMethod().invoke(data, newValue);
                this.tableViewer.refresh(data);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private PropertyDescriptor getDescriptor(Object element, String property) {
        BeanInfo beanInfo = this.getBeanInfo(element);
        if (beanInfo != null) {
            PropertyDescriptor[] propertyDescriptors;
            PropertyDescriptor[] propertyDescriptorArray = propertyDescriptors = beanInfo.getPropertyDescriptors();
            int n = propertyDescriptors.length;
            int n2 = 0;
            while (n2 < n) {
                PropertyDescriptor propertyDescriptor = propertyDescriptorArray[n2];
                if (propertyDescriptor.getName().equalsIgnoreCase(property)) {
                    return propertyDescriptor;
                }
                ++n2;
            }
        }
        return null;
    }
}

