/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.xwt.jface;

import org.eclipse.e4.xwt.XWT;
import org.eclipse.e4.xwt.XWTException;
import org.eclipse.e4.xwt.internal.core.Core;
import org.eclipse.e4.xwt.internal.utils.UserData;
import org.eclipse.e4.xwt.jface.JFacesHelper;
import org.eclipse.e4.xwt.metadata.IMetaclass;
import org.eclipse.e4.xwt.metadata.IProperty;
import org.eclipse.jface.viewers.AbstractTableViewer;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;

public class DefaultViewerLabelProvider
implements ITableLabelProvider,
ILabelProvider {
    private Viewer viewer;
    protected String bindingPath;
    private IProperty columnsProperty;

    public DefaultViewerLabelProvider(Viewer viewer) {
        this.viewer = viewer;
    }

    public String getBindingPath() {
        return this.bindingPath;
    }

    public void setBindingPath(String bindingPath) {
        this.bindingPath = bindingPath;
    }

    protected IProperty getColumnsProperty() {
        if (this.columnsProperty == null) {
            IMetaclass metaclass = XWT.getMetaclass(this.viewer.getClass());
            this.columnsProperty = metaclass.findProperty("columns");
            if (this.columnsProperty == null) {
                throw new XWTException("Columns property is not found.");
            }
        }
        return this.columnsProperty;
    }

    protected Viewer getViewer() {
        return this.viewer;
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    public Image getImage(Object element) {
        return this.getColumnImage(element, 0);
    }

    public String getText(Object dataContext) {
        return this.getColumnText(dataContext, 0);
    }

    public String getColumnText(Object element, int columnIndex) {
        return JFacesHelper.getColumnText(this.getViewer(), element, columnIndex, this.getPaths());
    }

    public Image getColumnImage(Object element, int columnIndex) {
        return JFacesHelper.getColumnImage(this.getViewer(), element, columnIndex, this.getPaths());
    }

    protected Object[] getPaths() {
        Viewer viewer = this.getViewer();
        if (viewer instanceof AbstractTableViewer) {
            Object[] objects = ((AbstractTableViewer)this.getViewer()).getColumnProperties();
            int i = 0;
            while (i < objects.length) {
                if (objects[i] == null) {
                    objects[i] = this.getBindingPath();
                }
                ++i;
            }
            return objects;
        }
        String path = this.bindingPath;
        if (path == null) {
            path = (String)UserData.getLocalData((Object)this.getViewer(), "_XWT.TableViewerColumnDisplayPath");
        }
        if (path == null) {
            return Core.EMPTY_ARRAY;
        }
        return new String[]{path};
    }
}

