/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.gallery;

import org.eclipse.nebula.widgets.gallery.AbstractGridGroupRenderer;
import org.eclipse.nebula.widgets.gallery.Gallery;
import org.eclipse.nebula.widgets.gallery.GalleryItem;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;

public class NoGroupRenderer
extends AbstractGridGroupRenderer {
    static int OFFSET = 0;

    public void draw(GC gc, GalleryItem group, int x, int y, int clipX, int clipY, int clipWidth, int clipHeight) {
        int[] indexes = this.getVisibleItems(group, x, y, clipX, clipY, clipWidth, clipHeight, OFFSET);
        if (indexes != null && indexes.length > 0) {
            int i = indexes.length - 1;
            while (i >= 0) {
                boolean selected = group.isSelected(group.getItem(indexes[i]));
                if (Gallery.DEBUG) {
                    System.out.println("Selected : " + selected + " index : " + indexes[i] + "item : " + (Object)((Object)group.getItem(indexes[i])));
                }
                this.drawItem(gc, indexes[i], selected, group, OFFSET);
                --i;
            }
        }
    }

    public void layout(GC gc, GalleryItem group) {
        int countLocal = group.getItemCount();
        if (this.gallery.isVertical()) {
            int sizeX = group.width;
            group.height = OFFSET;
            Point l = this.gridLayout(sizeX, countLocal, this.itemWidth);
            int hCount = l.x;
            int vCount = l.y;
            if (this.autoMargin) {
                this.margin = this.calculateMargins(sizeX, hCount, this.itemWidth);
            }
            Point s = this.getSize(hCount, vCount, this.itemWidth, this.itemHeight, this.minMargin, this.margin);
            group.height += s.y;
            group.setData("g.h", new Integer(hCount));
            group.setData("g.v", new Integer(vCount));
        } else {
            int sizeY = group.height;
            group.width = OFFSET;
            Point l = this.gridLayout(sizeY, countLocal, this.itemHeight);
            int vCount = l.x;
            int hCount = l.y;
            if (this.autoMargin) {
                this.margin = this.calculateMargins(sizeY, vCount, this.itemHeight);
            }
            Point s = this.getSize(hCount, vCount, this.itemWidth, this.itemHeight, this.minMargin, this.margin);
            group.width += s.x;
            group.setData("g.h", new Integer(hCount));
            group.setData("g.v", new Integer(vCount));
        }
    }

    public GalleryItem getItem(GalleryItem group, Point coords) {
        return super.getItem(group, coords, OFFSET);
    }

    public boolean mouseDown(GalleryItem group, MouseEvent e, Point coords) {
        return true;
    }

    public Rectangle getSize(GalleryItem item) {
        return super.getSize(item, OFFSET);
    }
}

