/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.piccolo.activities;

import edu.umd.cs.piccolo.activities.TimerQueue;
import org.eclipse.swt.widgets.Display;

public class Timer {
    private boolean notify = false;
    int initialDelay;
    int delay;
    boolean repeats = true;
    boolean coalesce = true;
    Runnable doPostEvent = null;
    Display display = null;
    long expirationTime;
    Timer nextTimer;
    boolean running;
    private Runnable listener;

    public Timer(Display display, int delay, Runnable runnable) {
        this.listener = runnable;
        this.delay = delay;
        this.initialDelay = delay;
        this.doPostEvent = new DoPostEvent();
        this.display = display;
    }

    protected void runListener() {
        this.listener.run();
    }

    TimerQueue timerQueue() {
        return TimerQueue.sharedInstance(this.display);
    }

    public void setDelay(int delay) {
        if (delay < 0) {
            throw new IllegalArgumentException("Invalid delay: " + delay);
        }
        this.delay = delay;
    }

    public int getDelay() {
        return this.delay;
    }

    public void setInitialDelay(int initialDelay) {
        if (initialDelay < 0) {
            throw new IllegalArgumentException("Invalid initial delay: " + initialDelay);
        }
        this.initialDelay = initialDelay;
    }

    public int getInitialDelay() {
        return this.initialDelay;
    }

    public void setRepeats(boolean flag) {
        this.repeats = flag;
    }

    public boolean isRepeats() {
        return this.repeats;
    }

    public void setCoalesce(boolean flag) {
        boolean old = this.coalesce;
        this.coalesce = flag;
        if (!old && this.coalesce) {
            this.cancelEventOverride();
        }
    }

    public boolean isCoalesce() {
        return this.coalesce;
    }

    public void start() {
        this.timerQueue().addTimer(this, System.currentTimeMillis() + (long)this.getInitialDelay());
    }

    public boolean isRunning() {
        return this.timerQueue().containsTimer(this);
    }

    public void stop() {
        this.timerQueue().removeTimer(this);
        this.cancelEventOverride();
    }

    public void restart() {
        this.stop();
        this.start();
    }

    synchronized void cancelEventOverride() {
        this.notify = false;
    }

    synchronized void postOverride() {
        if (!this.notify || !this.coalesce) {
            this.notify = true;
            this.display.asyncExec(this.doPostEvent);
        }
    }

    class DoPostEvent
    implements Runnable {
        DoPostEvent() {
        }

        public void run() {
            if (Timer.this.notify) {
                Timer.this.runListener();
                if (Timer.this.coalesce) {
                    Timer.this.cancelEventOverride();
                }
            }
        }

        Timer getTimer() {
            return Timer.this;
        }
    }
}

