/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.xwt.ui.editor.dnd;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.e4.xwt.ui.editor.XWTEditor;
import org.eclipse.e4.xwt.ui.editor.dnd.DnDAdapterImpl;
import org.eclipse.e4.xwt.ui.utils.ProjectContext;
import org.eclipse.e4.xwt.vex.VEXTextEditorHelper;
import org.eclipse.e4.xwt.vex.toolpalette.ContextType;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.wst.sse.ui.StructuredTextEditor;
import org.eclipse.wst.sse.ui.internal.StructuredTextViewer;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMAttr;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserDefinedDnDAdapter
extends DnDAdapterImpl {
    private Map<String, String> nsURIs = new HashMap<String, String>();
    private Map<String, Boolean> prefixStatus = new HashMap<String, Boolean>();
    private String name;
    private String namespace;
    private String prefix;

    public UserDefinedDnDAdapter(XWTEditor editor) {
        super(editor);
        this.updateNsURIs();
    }

    @Override
    public boolean isAccept(Object obj) {
        if (obj instanceof ICompilationUnit) {
            ICompilationUnit unit = (ICompilationUnit)obj;
            IType type = unit.findPrimaryType();
            String name = type.getElementName();
            IJavaProject javaProject = unit.getJavaProject();
            String fullyQualifiedName = type.getFullyQualifiedName();
            try {
                ProjectContext context = ProjectContext.getContext((IJavaProject)javaProject);
                Class<?> clazz = context.getClassLoader().loadClass(fullyQualifiedName);
                this.name = clazz.getSimpleName();
                this.namespace = "clr-namespace:" + type.getPackageFragment().getElementName();
                return Composite.class.isAssignableFrom(clazz) && clazz.getResource(String.valueOf(name) + ".xwt") != null;
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        } else if (obj instanceof IFile) {
            IResource java;
            IFile file = (IFile)obj;
            String ext = file.getFileExtension();
            String name = file.getName();
            if ("xwt".equals(ext) && (java = file.getParent().findMember(name.replace("xwt", "java"))).exists()) {
                IProject project = file.getProject();
                IJavaProject javaProject = JavaCore.create((IProject)project);
                try {
                    ICompilationUnit unit = (ICompilationUnit)JavaCore.create((IResource)java);
                    IType type = unit.findPrimaryType();
                    String fullyQualifiedName = type.getFullyQualifiedName();
                    ProjectContext context = ProjectContext.getContext((IJavaProject)javaProject);
                    Class<?> clazz = context.getClassLoader().loadClass(fullyQualifiedName);
                    this.name = clazz.getSimpleName();
                    this.namespace = "clr-namespace:" + type.getPackageFragment().getElementName();
                    return Composite.class.isAssignableFrom(clazz);
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                }
            }
        }
        return false;
    }

    public String getName() {
        String p = this.getPrefix();
        return p == null ? this.name : String.valueOf(p) + ":" + this.name;
    }

    private void updateNsURIs() {
        StructuredTextEditor textEditor = this.getEditor().getTextEditor();
        StructuredTextViewer textViewer = textEditor.getTextViewer();
        IDOMNode node = VEXTextEditorHelper.getNode((ITextViewer)textViewer, (int)0);
        this.updateNsURIs(node, this.nsURIs);
    }

    private String genPrefix(Collection<String> existings) {
        char[] c = new char[]{'q', 'w', 'e', 'r', 't', 'y', 'u', 'i', 'o', 'p', 'a', 's', 'd', 'f', 'g', 'h', 'j', 'k', 'l', 'z', 'c', 'v', 'b', 'n', 'm'};
        Random random = new Random();
        String prefix = Character.toString(c[Math.abs(random.nextInt()) % c.length]);
        while (existings.contains(prefix)) {
            prefix = Character.toString(c[Math.abs(random.nextInt()) % c.length]);
        }
        return prefix;
    }

    public void updateNsURIs(Object obj, Map<String, String> nsURIs) {
        if (obj instanceof Node) {
            NodeList childNodes;
            NamedNodeMap attributes;
            Node node = (Node)obj;
            String p = node.getPrefix();
            String ns = node.getNamespaceURI();
            if (ns != null) {
                nsURIs.put(ns, p);
            }
            if ((attributes = node.getAttributes()) != null) {
                int i = 0;
                while (i < attributes.getLength()) {
                    Node attr = attributes.item(i);
                    String nodeName = attr.getNodeName();
                    if (nodeName.startsWith("xmlns:")) {
                        p = nodeName.substring("xmlns:".length());
                        ns = attr.getNodeValue();
                        if (ns != null) {
                            nsURIs.put(ns, p);
                        }
                    }
                    ++i;
                }
            }
            if ((childNodes = node.getChildNodes()) != null) {
                int i = 0;
                while (i < childNodes.getLength()) {
                    this.updateNsURIs(childNodes.item(i), nsURIs);
                    ++i;
                }
            }
        }
    }

    public String getContent() {
        return "<" + this.getName() + "/>";
    }

    public String getPrefix() {
        this.updateNsURIs();
        this.prefix = this.nsURIs.get(this.namespace);
        if (this.prefix == null) {
            this.prefix = this.genPrefix(this.nsURIs.values());
            this.prefixStatus.put(this.prefix, Boolean.TRUE);
            this.nsURIs.put(this.namespace, this.prefix);
        }
        return this.prefix;
    }

    public boolean isNsURINew() {
        String p = this.getPrefix();
        if (p == null) {
            return false;
        }
        return Boolean.TRUE.equals(this.prefixStatus.get(p));
    }

    public String getNamespace() {
        return this.namespace;
    }

    @Override
    protected Template createTemplate(Object selection) {
        return new Template(this.name, "", ContextType.XML_TAG.getName(), this.getContent(), true);
    }

    @Override
    public void dropAccept(DropTargetEvent event) {
        if (!this.isAccept()) {
            return;
        }
        String prefix = this.getPrefix();
        if (prefix != null && this.isNsURINew()) {
            String pattern = "xmlns:" + prefix + "=\"" + this.getNamespace() + "\" ";
            Template tem = new Template("xmlns:" + prefix, "", ContextType.XML_ATTRIBUTE.getName(), pattern, true);
            StructuredTextEditor textEditor = this.getEditor().getTextEditor();
            StructuredTextViewer textViewer = textEditor.getTextViewer();
            IDOMNode node = VEXTextEditorHelper.getNode((ITextViewer)textViewer, (int)0);
            NamedNodeMap attributes = node.getAttributes();
            int dropNsIndex = 0;
            int i = 0;
            while (i < attributes.getLength()) {
                IDOMAttr attr = (IDOMAttr)attributes.item(i);
                String nodeName = attr.getNodeName();
                if ("xmlns:x".equals(nodeName)) {
                    dropNsIndex = attr.getEndOffset();
                    break;
                }
                ++i;
            }
            this.setDropCaretOffset(this.getDropCaretOffset() + pattern.length());
            this.drop(tem, dropNsIndex, 0);
            this.prefixStatus.put(prefix, Boolean.FALSE);
        }
    }

    @Override
    public ContextType getContextType() {
        return ContextType.XML_TAG;
    }

    @Override
    public String getScope() {
        return "Composite";
    }
}

