/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.platform.discovery.runtime.internal.search.activation;

import org.eclipse.platform.discovery.runtime.internal.ISearchProviderActivationConfig;
import org.eclipse.platform.discovery.runtime.internal.ProviderNotFoundException;
import org.eclipse.platform.discovery.runtime.internal.impl.XpParsersFactory;
import org.eclipse.platform.discovery.runtime.internal.model.descriptions.IDestinationCategoryDescription;
import org.eclipse.platform.discovery.runtime.internal.model.descriptions.IObjectTypeDescription;
import org.eclipse.platform.discovery.runtime.internal.model.descriptions.ISearchProviderDescription;
import org.eclipse.platform.discovery.runtime.internal.xp.IDestinationCategoryExtensionParser;
import org.eclipse.platform.discovery.runtime.internal.xp.IDestinationsProviderExtensionParser;
import org.eclipse.platform.discovery.runtime.internal.xp.IObjectTypeExtensionParser;
import org.eclipse.platform.discovery.runtime.internal.xp.ISearchProvidersExtensionParser;

public class SearchProviderActivationConfigDummy
implements ISearchProviderActivationConfig {
    private final XpParsersFactory parsersFactory = new XpParsersFactory();

    @Override
    public ISearchProvidersExtensionParser getSearchProvidersExtensionParser() {
        return this.parsersFactory.createSearchProviderParser();
    }

    @Override
    public IObjectTypeExtensionParser getObjectTypeExtensionParser() {
        return this.parsersFactory.createObjectTypeParser();
    }

    @Override
    public IDestinationCategoryExtensionParser getDestinationCategoryExtensionParser() {
        return this.parsersFactory.createDestinationsCategoryParser();
    }

    @Override
    public IDestinationsProviderExtensionParser getDestinationsProviderExtensionParser() {
        return this.parsersFactory.createDestinationsProviderParser();
    }

    @Override
    public ISearchProviderDescription getActiveSearchProviderDescription(IObjectTypeDescription objectType, IDestinationCategoryDescription destinationCategory) throws ProviderNotFoundException {
        for (ISearchProviderDescription searchProvider : this.getSearchProvidersExtensionParser().readContributions()) {
            if (!searchProvider.getObjectType().getId().equals(objectType.getId())) continue;
            for (IDestinationCategoryDescription supportedCategory : searchProvider.getSupportedDestinationCategories()) {
                if (!supportedCategory.getId().equals(destinationCategory.getId())) continue;
                return searchProvider;
            }
        }
        throw new ProviderNotFoundException("No provider found for object id " + objectType.getId() + " and category id " + destinationCategory.getId());
    }
}

