/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.resources.semantic.examples;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.commands.IHandlerListener;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class HandlerUtilities
implements IHandler {
    HandlerUtilities() {
    }

    public boolean isEnabled() {
        return true;
    }

    public boolean isHandled() {
        return true;
    }

    public void removeHandlerListener(IHandlerListener handlerListener) {
    }

    public void addHandlerListener(IHandlerListener handlerListener) {
    }

    public void dispose() {
    }

    protected <T> T getSelectedObject(ExecutionEvent evt, Class T, boolean adapt) {
        IEvaluationContext ctx = (IEvaluationContext)evt.getApplicationContext();
        ISelection selection = (ISelection)ctx.getVariable("selection");
        if (!(selection instanceof IStructuredSelection)) {
            return null;
        }
        IStructuredSelection ssel = (IStructuredSelection)selection;
        if (ssel.size() != 1) {
            return null;
        }
        if (!(ssel.getFirstElement() instanceof IResource)) {
            return null;
        }
        IResource r = (IResource)ssel.getFirstElement();
        if (adapt) {
            Object adapted = r.getAdapter(T);
            try {
                return (T)adapted;
            }
            catch (ClassCastException classCastException) {
                return null;
            }
        }
        try {
            return (T)r;
        }
        catch (ClassCastException classCastException) {
            return null;
        }
    }

    protected void showPopup(final String title, final String message) {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                MessageDialog.openInformation(null, (String)title, (String)message);
            }
        });
    }

    protected void submit(Shell shell, IRunnableWithProgress runnable) throws InterruptedException, InvocationTargetException {
        new ProgressMonitorDialog(shell).run(true, true, runnable);
    }
}

