/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.databinding.observable;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.databinding.observable.list.ListDiff;
import org.eclipse.core.databinding.observable.list.ListDiffEntry;
import org.eclipse.core.databinding.observable.map.MapDiff;
import org.eclipse.core.databinding.observable.set.SetDiff;
import org.eclipse.core.databinding.observable.value.ValueDiff;
import org.eclipse.core.internal.databinding.observable.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Diffs {
    public static <E> ListDiff<E> computeListDiff(List<E> oldList, List<E> newList) {
        ArrayList<ListDiffEntry<E>> diffEntries = new ArrayList<ListDiffEntry<E>>();
        Diffs.createListDiffs(new ArrayList<E>(oldList), newList, diffEntries);
        ListDiff<E> listDiff = Diffs.createListDiff(diffEntries);
        return listDiff;
    }

    public static <E> ListDiff<E> computeAndCastListDiff(List<?> oldList, List<?> newList, Class<E> elementType) {
        ArrayList<ListDiffEntry<E>> diffEntries = new ArrayList<ListDiffEntry<E>>();
        ArrayList<E> oldListTyped = new ArrayList<E>();
        for (Object oldElement : oldList) {
            oldListTyped.add(elementType.cast(oldElement));
        }
        ArrayList<E> newListTyped = new ArrayList<E>();
        for (Object newElement : newList) {
            newListTyped.add(elementType.cast(newElement));
        }
        Diffs.createListDiffs(oldListTyped, newListTyped, diffEntries);
        ListDiff<E> listDiff = Diffs.createListDiff(diffEntries);
        return listDiff;
    }

    public static <E> ListDiff<E> computeLazyListDiff(final List<E> oldList, final List<E> newList) {
        return new ListDiff<E>(){
            ListDiff<E> lazyDiff;

            @Override
            public ListDiffEntry<?>[] getDifferences() {
                if (this.lazyDiff == null) {
                    this.lazyDiff = Diffs.computeListDiff(oldList, newList);
                }
                return this.lazyDiff.getDifferences();
            }

            @Override
            public List<ListDiffEntry<E>> getDifferencesAsList() {
                if (this.lazyDiff == null) {
                    this.lazyDiff = Diffs.computeListDiff(oldList, newList);
                }
                return this.lazyDiff.getDifferencesAsList();
            }
        };
    }

    private static <E> void createListDiffs(List<E> oldList, List<E> newList, List<ListDiffEntry<E>> listDiffs) {
        int index = 0;
        for (E newValue : newList) {
            if (oldList.size() <= index) {
                listDiffs.add(Diffs.createListDiffEntry(index, true, newValue));
            } else {
                boolean done;
                do {
                    done = true;
                    E oldValue = oldList.get(index);
                    if (!(oldValue == null ? newValue != null : !oldValue.equals(newValue))) continue;
                    int oldIndexOfNewValue = Diffs.listIndexOf(oldList, newValue, index);
                    if (oldIndexOfNewValue != -1) {
                        int newIndexOfOldValue = Diffs.listIndexOf(newList, oldValue, index);
                        if (newIndexOfOldValue == -1) {
                            listDiffs.add(Diffs.createListDiffEntry(index, false, oldValue));
                            oldList.remove(index);
                            done = false;
                            continue;
                        }
                        if (newIndexOfOldValue > oldIndexOfNewValue) {
                            if (oldList.size() <= newIndexOfOldValue) {
                                newIndexOfOldValue = oldList.size() - 1;
                            }
                            listDiffs.add(Diffs.createListDiffEntry(index, false, oldValue));
                            oldList.remove(index);
                            listDiffs.add(Diffs.createListDiffEntry(newIndexOfOldValue, true, oldValue));
                            oldList.add(newIndexOfOldValue, oldValue);
                            done = false;
                            continue;
                        }
                        listDiffs.add(Diffs.createListDiffEntry(oldIndexOfNewValue, false, newValue));
                        oldList.remove(oldIndexOfNewValue);
                        listDiffs.add(Diffs.createListDiffEntry(index, true, newValue));
                        oldList.add(index, newValue);
                        continue;
                    }
                    oldList.add(index, newValue);
                    listDiffs.add(Diffs.createListDiffEntry(index, true, newValue));
                } while (!done);
            }
            ++index;
        }
        int i = oldList.size();
        while (i > index) {
            listDiffs.add(Diffs.createListDiffEntry(--i, false, oldList.get(i)));
        }
    }

    private static <E> int listIndexOf(List<E> list, Object object, int index) {
        int size = list.size();
        int i = index;
        while (i < size) {
            E candidate = list.get(i);
            if (candidate == null ? object == null : candidate.equals(object)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static final boolean equals(Object left, Object right) {
        return left == null ? right == null : right != null && left.equals(right);
    }

    public static <E> SetDiff<E> computeSetDiff(Set<E> oldSet, Set<E> newSet) {
        HashSet<E> additions = new HashSet<E>(newSet);
        additions.removeAll(oldSet);
        HashSet<E> removals = new HashSet<E>(oldSet);
        removals.removeAll(newSet);
        return Diffs.createSetDiff(additions, removals);
    }

    public static <E> SetDiff<E> computeAndCastSetDiff(Set<?> oldSet, Set<?> newSet, Class<E> elementType) {
        HashSet<E> additions = new HashSet<E>();
        for (Object newElement : newSet) {
            if (oldSet.contains(newElement)) continue;
            additions.add(elementType.cast(newElement));
        }
        HashSet<E> removals = new HashSet<E>();
        for (Object oldElement : oldSet) {
            if (newSet.contains(oldElement)) continue;
            removals.add(elementType.cast(oldElement));
        }
        return Diffs.createSetDiff(additions, removals);
    }

    public static <E> SetDiff<E> computeLazySetDiff(final Set<E> oldSet, final Set<E> newSet) {
        return new SetDiff<E>(){
            private SetDiff<E> lazyDiff;

            private SetDiff<E> getLazyDiff() {
                if (this.lazyDiff == null) {
                    this.lazyDiff = Diffs.computeSetDiff(oldSet, newSet);
                }
                return this.lazyDiff;
            }

            @Override
            public Set<E> getAdditions() {
                return this.getLazyDiff().getAdditions();
            }

            @Override
            public Set<E> getRemovals() {
                return this.getLazyDiff().getRemovals();
            }
        };
    }

    public static <K, V> MapDiff<K, V> computeMapDiff(Map<K, V> oldMap, Map<K, V> newMap) {
        final HashSet<K> addedKeys = new HashSet<K>(newMap.keySet());
        final HashSet<K> removedKeys = new HashSet<K>();
        final HashSet<K> changedKeys = new HashSet<K>();
        final HashMap<K, V> oldValues = new HashMap<K, V>();
        final HashMap<K, V> newValues = new HashMap<K, V>();
        for (Map.Entry<K, V> oldEntry : oldMap.entrySet()) {
            K oldKey = oldEntry.getKey();
            if (addedKeys.remove(oldKey)) {
                V newValue;
                V oldValue = oldEntry.getValue();
                if (Util.equals(oldValue, newValue = newMap.get(oldKey))) continue;
                changedKeys.add(oldKey);
                oldValues.put(oldKey, oldValue);
                newValues.put(oldKey, newValue);
                continue;
            }
            removedKeys.add(oldKey);
            oldValues.put(oldKey, oldEntry.getValue());
        }
        for (Map.Entry<K, V> newKey : addedKeys) {
            newValues.put(newKey, newMap.get(newKey));
        }
        return new MapDiff<K, V>(){

            @Override
            public Set<K> getAddedKeys() {
                return addedKeys;
            }

            @Override
            public Set<K> getChangedKeys() {
                return changedKeys;
            }

            @Override
            public Set<K> getRemovedKeys() {
                return removedKeys;
            }

            @Override
            public V getNewValue(Object key) {
                return newValues.get(key);
            }

            @Override
            public V getOldValue(Object key) {
                return oldValues.get(key);
            }
        };
    }

    public static <K, V> MapDiff<K, V> computeAndCastMapDiff(Map<?, ?> oldMap, Map<?, ?> newMap, Class<K> keyType, Class<V> valueType) {
        final HashSet<K> addedKeys = new HashSet<K>();
        final HashSet<K> removedKeys = new HashSet<K>();
        final HashSet<K> changedKeys = new HashSet<K>();
        final HashMap<K, V> oldValues = new HashMap<K, V>();
        final HashMap<Object, V> newValues = new HashMap<Object, V>();
        for (Object obj : newMap.keySet()) {
            addedKeys.add(keyType.cast(obj));
        }
        for (Map.Entry entry : oldMap.entrySet()) {
            K oldKey = keyType.cast(entry.getKey());
            V oldValue = valueType.cast(entry.getValue());
            if (addedKeys.remove(oldKey)) {
                V newValue = valueType.cast(newMap.get(oldKey));
                if (Util.equals(oldValue, newValue)) continue;
                changedKeys.add(oldKey);
                oldValues.put(oldKey, oldValue);
                newValues.put(oldKey, newValue);
                continue;
            }
            removedKeys.add(oldKey);
            oldValues.put(oldKey, oldValue);
        }
        for (Object newKey : addedKeys) {
            newValues.put(newKey, valueType.cast(newMap.get(newKey)));
        }
        return new MapDiff<K, V>(){

            @Override
            public Set<K> getAddedKeys() {
                return addedKeys;
            }

            @Override
            public Set<K> getChangedKeys() {
                return changedKeys;
            }

            @Override
            public Set<K> getRemovedKeys() {
                return removedKeys;
            }

            @Override
            public V getNewValue(Object key) {
                return newValues.get(key);
            }

            @Override
            public V getOldValue(Object key) {
                return oldValues.get(key);
            }
        };
    }

    public static <K, V> MapDiff<K, V> computeLazyMapDiff(final Map<K, V> oldMap, final Map<K, V> newMap) {
        return new MapDiff<K, V>(){
            private MapDiff<K, V> lazyDiff;

            private MapDiff<K, V> getLazyDiff() {
                if (this.lazyDiff == null) {
                    this.lazyDiff = Diffs.computeMapDiff(oldMap, newMap);
                }
                return this.lazyDiff;
            }

            @Override
            public Set<K> getAddedKeys() {
                return this.getLazyDiff().getAddedKeys();
            }

            @Override
            public Set<K> getRemovedKeys() {
                return this.getLazyDiff().getRemovedKeys();
            }

            @Override
            public Set<K> getChangedKeys() {
                return this.getLazyDiff().getChangedKeys();
            }

            @Override
            public V getOldValue(Object key) {
                return this.getLazyDiff().getOldValue(key);
            }

            @Override
            public V getNewValue(Object key) {
                return this.getLazyDiff().getNewValue(key);
            }
        };
    }

    public static <T> ValueDiff<T> createValueDiff(final T oldValue, final T newValue) {
        return new ValueDiff<T>(){

            @Override
            public T getOldValue() {
                return oldValue;
            }

            @Override
            public T getNewValue() {
                return newValue;
            }
        };
    }

    public static <E> SetDiff<E> createSetDiff(Set<E> additions, Set<E> removals) {
        final Set<E> unmodifiableAdditions = Collections.unmodifiableSet(additions);
        final Set<E> unmodifiableRemovals = Collections.unmodifiableSet(removals);
        return new SetDiff<E>(){

            @Override
            public Set<E> getAdditions() {
                return unmodifiableAdditions;
            }

            @Override
            public Set<E> getRemovals() {
                return unmodifiableRemovals;
            }
        };
    }

    public static <E> ListDiff<E> createListDiff(ListDiffEntry<E> difference) {
        return Diffs.createListDiff(Collections.singletonList(difference));
    }

    public static <E> ListDiff<E> createListDiff(ListDiffEntry<E> difference1, ListDiffEntry<E> difference2) {
        ArrayList<ListDiffEntry<ListDiffEntry<E>>> differences = new ArrayList<ListDiffEntry<ListDiffEntry<E>>>(2);
        differences.add(difference1);
        differences.add(difference2);
        return Diffs.createListDiff(differences);
    }

    public static <E> ListDiff<E> createListDiff(final ListDiffEntry<E>[] differences) {
        return new ListDiff<E>(){

            @Override
            public ListDiffEntry<?>[] getDifferences() {
                return differences;
            }

            @Override
            public List<ListDiffEntry<E>> getDifferencesAsList() {
                return Arrays.asList(differences);
            }
        };
    }

    public static <E> ListDiff<E> createListDiff(final List<ListDiffEntry<E>> differences) {
        final ListDiffEntry[] differencesArray = differences.toArray(new ListDiffEntry[differences.size()]);
        return new ListDiff<E>(){

            @Override
            public ListDiffEntry<?>[] getDifferences() {
                return differencesArray;
            }

            @Override
            public List<ListDiffEntry<E>> getDifferencesAsList() {
                return differences;
            }
        };
    }

    public static <E> ListDiffEntry<E> createListDiffEntry(final int position, final boolean isAddition, final E element) {
        return new ListDiffEntry<E>(){

            @Override
            public int getPosition() {
                return position;
            }

            @Override
            public boolean isAddition() {
                return isAddition;
            }

            @Override
            public E getElement() {
                return element;
            }
        };
    }

    public static <K, V> MapDiff<K, V> createMapDiffSingleAdd(final K addedKey, final V newValue) {
        return new MapDiff<K, V>(){

            @Override
            public Set<K> getAddedKeys() {
                return Collections.singleton(addedKey);
            }

            @Override
            public Set<K> getChangedKeys() {
                return Collections.emptySet();
            }

            @Override
            public V getNewValue(Object key) {
                return newValue;
            }

            @Override
            public V getOldValue(Object key) {
                return null;
            }

            @Override
            public Set<K> getRemovedKeys() {
                return Collections.emptySet();
            }
        };
    }

    public static <K, V> MapDiff<K, V> createMapDiffSingleChange(final K existingKey, final V oldValue, final V newValue) {
        return new MapDiff<K, V>(){

            @Override
            public Set<K> getAddedKeys() {
                return Collections.emptySet();
            }

            @Override
            public Set<K> getChangedKeys() {
                return Collections.singleton(existingKey);
            }

            @Override
            public V getNewValue(Object key) {
                return newValue;
            }

            @Override
            public V getOldValue(Object key) {
                return oldValue;
            }

            @Override
            public Set<K> getRemovedKeys() {
                return Collections.emptySet();
            }
        };
    }

    public static <K, V> MapDiff<K, V> createMapDiffSingleRemove(final K removedKey, final V oldValue) {
        return new MapDiff<K, V>(){

            @Override
            public Set<K> getAddedKeys() {
                return Collections.emptySet();
            }

            @Override
            public Set<K> getChangedKeys() {
                return Collections.emptySet();
            }

            @Override
            public V getNewValue(Object key) {
                return null;
            }

            @Override
            public V getOldValue(Object key) {
                return oldValue;
            }

            @Override
            public Set<K> getRemovedKeys() {
                return Collections.singleton(removedKey);
            }
        };
    }

    public static <K, V> MapDiff<K, V> createMapDiffRemoveAll(final Map<K, V> copyOfOldMap) {
        return new MapDiff<K, V>(){

            @Override
            public Set<K> getAddedKeys() {
                return Collections.emptySet();
            }

            @Override
            public Set<K> getChangedKeys() {
                return Collections.emptySet();
            }

            @Override
            public V getNewValue(Object key) {
                return null;
            }

            @Override
            public V getOldValue(Object key) {
                return copyOfOldMap.get(key);
            }

            @Override
            public Set<K> getRemovedKeys() {
                return copyOfOldMap.keySet();
            }
        };
    }

    public static <K, V> MapDiff<K, V> createMapDiff(final Set<K> addedKeys, final Set<K> removedKeys, final Set<K> changedKeys, final Map<K, V> oldValues, final Map<K, V> newValues) {
        return new MapDiff<K, V>(){

            @Override
            public Set<K> getAddedKeys() {
                return addedKeys;
            }

            @Override
            public Set<K> getChangedKeys() {
                return changedKeys;
            }

            @Override
            public V getNewValue(Object key) {
                return newValues.get(key);
            }

            @Override
            public V getOldValue(Object key) {
                return oldValues.get(key);
            }

            @Override
            public Set<K> getRemovedKeys() {
                return removedKeys;
            }
        };
    }
}

