/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.databinding.observable.map;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.map.BidiObservableMap;
import org.eclipse.core.databinding.observable.map.IMapChangeListener;
import org.eclipse.core.databinding.observable.map.IObservableMap;
import org.eclipse.core.databinding.observable.map.MapChangeEvent;
import org.eclipse.core.databinding.observable.map.MapDiff;
import org.eclipse.core.databinding.observable.map.ObservableMap;
import org.eclipse.core.databinding.observable.masterdetail.IObservableFactory;
import org.eclipse.core.databinding.observable.set.WritableSet;
import org.eclipse.core.runtime.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeMap<K, I, V>
extends ObservableMap<K, V> {
    private Set<I> pendingAdds = new HashSet<I>();
    private Map<I, K> pendingRemoves = new HashMap<I, K>();
    private Map<I, I> pendingChanges = new HashMap<I, I>();
    private IMapChangeListener<K, I> firstMapListener = new IMapChangeListener<K, I>(){

        @Override
        public void handleMapChange(MapChangeEvent<K, I> event) {
            Object oldValue;
            MapDiff diff = event.diff;
            HashSet rangeSetAdditions = new HashSet();
            HashSet rangeSetRemovals = new HashSet();
            final HashSet adds = new HashSet();
            final HashSet changes = new HashSet();
            final HashSet removes = new HashSet();
            final HashMap oldValues = new HashMap();
            for (Object addedKey : diff.getAddedKeys()) {
                Object newValue = diff.getNewValue(addedKey);
                if (!CompositeMap.this.rangeSet.contains(newValue)) {
                    CompositeMap.this.pendingAdds.add(newValue);
                    rangeSetAdditions.add(newValue);
                    continue;
                }
                adds.add(addedKey);
                CompositeMap.this.wrappedMap.put(addedKey, CompositeMap.this.secondMap.get(newValue));
            }
            for (Object changedKey : diff.getChangedKeys()) {
                boolean added;
                oldValue = diff.getOldValue(changedKey);
                Object newValue = diff.getNewValue(changedKey);
                boolean removed = CompositeMap.this.firstMap.getKeys(oldValue).isEmpty();
                boolean bl = added = !CompositeMap.this.rangeSet.contains(newValue);
                if (removed) {
                    CompositeMap.this.pendingRemoves.put(oldValue, changedKey);
                    rangeSetRemovals.add(oldValue);
                }
                if (added) {
                    CompositeMap.this.pendingAdds.add(newValue);
                    rangeSetAdditions.add(newValue);
                }
                if (added || removed) {
                    CompositeMap.this.pendingChanges.put(oldValue, newValue);
                    CompositeMap.this.pendingChanges.put(newValue, oldValue);
                    continue;
                }
                changes.add(changedKey);
                oldValues.put(changedKey, CompositeMap.this.secondMap.get(oldValue));
                CompositeMap.this.wrappedMap.put(changedKey, CompositeMap.this.secondMap.get(newValue));
            }
            for (Object removedKey : diff.getRemovedKeys()) {
                oldValue = diff.getOldValue(removedKey);
                if (CompositeMap.this.firstMap.getKeys(oldValue).isEmpty()) {
                    CompositeMap.this.pendingRemoves.put(oldValue, removedKey);
                    rangeSetRemovals.add(oldValue);
                    continue;
                }
                removes.add(removedKey);
                oldValues.put(removedKey, CompositeMap.this.secondMap.get(oldValue));
                CompositeMap.this.wrappedMap.remove(removedKey);
            }
            if (adds.size() > 0 || removes.size() > 0 || changes.size() > 0) {
                CompositeMap.this.fireMapChange(new MapDiff<K, V>(){

                    @Override
                    public Set<K> getAddedKeys() {
                        return adds;
                    }

                    @Override
                    public Set<K> getChangedKeys() {
                        return changes;
                    }

                    @Override
                    public V getNewValue(Object key) {
                        return (this).CompositeMap.this.wrappedMap.get(key);
                    }

                    @Override
                    public V getOldValue(Object key) {
                        return oldValues.get(key);
                    }

                    @Override
                    public Set<K> getRemovedKeys() {
                        return removes;
                    }
                });
            }
            if (rangeSetAdditions.size() > 0 || rangeSetRemovals.size() > 0) {
                CompositeMap.this.rangeSet.addAndRemove(rangeSetAdditions, rangeSetRemovals);
            }
        }
    };
    private IMapChangeListener<I, V> secondMapListener = new IMapChangeListener<I, V>(){

        @Override
        public void handleMapChange(MapChangeEvent<I, V> event) {
            Set elements;
            MapDiff diff = event.diff;
            final HashSet adds = new HashSet();
            final HashSet<Object> changes = new HashSet<Object>();
            final HashSet removes = new HashSet();
            final HashMap oldValues = new HashMap();
            final HashMap newValues = new HashMap();
            HashSet addedKeys = new HashSet(diff.getAddedKeys());
            HashSet removedKeys = new HashSet(diff.getRemovedKeys());
            for (Object addedKey : addedKeys) {
                elements = CompositeMap.this.firstMap.getKeys(addedKey);
                Object newValue = diff.getNewValue(addedKey);
                if (CompositeMap.this.pendingChanges.containsKey(addedKey)) {
                    Object oldKey = CompositeMap.this.pendingChanges.remove(addedKey);
                    Object oldValue = removedKeys.remove(oldKey) ? diff.getOldValue(oldKey) : CompositeMap.this.secondMap.get(oldKey);
                    CompositeMap.this.pendingChanges.remove(oldKey);
                    CompositeMap.this.pendingAdds.remove(addedKey);
                    CompositeMap.this.pendingRemoves.remove(oldKey);
                    for (Object element : elements) {
                        changes.add(element);
                        oldValues.put(element, oldValue);
                        newValues.put(element, newValue);
                        CompositeMap.this.wrappedMap.put(element, newValue);
                    }
                    continue;
                }
                if (CompositeMap.this.pendingAdds.remove(addedKey)) {
                    for (Object element : elements) {
                        adds.add(element);
                        newValues.put(element, newValue);
                        CompositeMap.this.wrappedMap.put(element, newValue);
                    }
                    continue;
                }
                Assert.isTrue((boolean)false, (String)"unexpected case");
            }
            for (Object changedKey : diff.getChangedKeys()) {
                elements = CompositeMap.this.firstMap.getKeys(changedKey);
                for (Object element : elements) {
                    changes.add(element);
                    oldValues.put(element, diff.getOldValue(changedKey));
                    Object newValue = diff.getNewValue(changedKey);
                    newValues.put(element, newValue);
                    CompositeMap.this.wrappedMap.put(element, newValue);
                }
            }
            for (Object removedKey : removedKeys) {
                Object element = CompositeMap.this.pendingRemoves.remove(removedKey);
                if (element != null) {
                    if (CompositeMap.this.pendingChanges.containsKey(removedKey)) {
                        Object newKey = CompositeMap.this.pendingChanges.remove(removedKey);
                        CompositeMap.this.pendingChanges.remove(newKey);
                        CompositeMap.this.pendingAdds.remove(newKey);
                        CompositeMap.this.pendingRemoves.remove(removedKey);
                        changes.add(element);
                        oldValues.put(element, diff.getOldValue(removedKey));
                        Object newValue = CompositeMap.this.secondMap.get(newKey);
                        newValues.put(element, newValue);
                        CompositeMap.this.wrappedMap.put(element, newValue);
                        continue;
                    }
                    removes.add(element);
                    Object oldValue = diff.getOldValue(removedKey);
                    oldValues.put(element, oldValue);
                    CompositeMap.this.wrappedMap.remove(element);
                    continue;
                }
                Assert.isTrue((boolean)false, (String)"unexpected case");
            }
            if (adds.size() > 0 || removes.size() > 0 || changes.size() > 0) {
                CompositeMap.this.fireMapChange(new MapDiff<K, V>(){

                    @Override
                    public Set<K> getAddedKeys() {
                        return adds;
                    }

                    @Override
                    public Set<K> getChangedKeys() {
                        return changes;
                    }

                    @Override
                    public V getNewValue(Object key) {
                        return newValues.get(key);
                    }

                    @Override
                    public V getOldValue(Object key) {
                        return oldValues.get(key);
                    }

                    @Override
                    public Set<K> getRemovedKeys() {
                        return removes;
                    }
                });
            }
        }
    };
    private BidiObservableMap<K, I> firstMap;
    private IObservableMap<I, V> secondMap;
    private WritableSetPlus<I> rangeSet = new WritableSetPlus();

    public CompositeMap(IObservableMap<K, I> firstMap, IObservableFactory<Set<I>, IObservableMap<I, V>> secondMapFactory) {
        super(firstMap.getRealm(), new HashMap());
        this.firstMap = new BidiObservableMap<K, I>(firstMap);
        this.firstMap.addMapChangeListener(this.firstMapListener);
        this.rangeSet.addAll(this.firstMap.values());
        this.secondMap = secondMapFactory.createObservable(this.rangeSet);
        this.secondMap.addMapChangeListener(this.secondMapListener);
        for (Map.Entry entry : this.firstMap.entrySet()) {
            this.wrappedMap.put(entry.getKey(), this.secondMap.get(entry.getValue()));
        }
    }

    @Override
    public Object getKeyType() {
        return this.firstMap.getKeyType();
    }

    @Override
    public Object getValueType() {
        return this.secondMap.getValueType();
    }

    @Override
    public synchronized void dispose() {
        super.dispose();
        if (this.firstMap != null) {
            this.firstMap.removeMapChangeListener(this.firstMapListener);
            this.firstMap = null;
        }
        if (this.secondMap != null) {
            this.secondMap.dispose();
            this.secondMap = null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class WritableSetPlus<E>
    extends WritableSet<E> {
        private WritableSetPlus() {
        }

        void addAndRemove(Set<E> additions, Set<E> removals) {
            this.wrappedSet.removeAll(removals);
            this.wrappedSet.addAll(additions);
            this.fireSetChange(Diffs.createSetDiff(additions, removals));
        }
    }
}

