/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.databinding.observable.value;

import org.eclipse.core.databinding.observable.AbstractObservable;
import org.eclipse.core.databinding.observable.ObservableTracker;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.core.databinding.observable.value.ValueChangeEvent;
import org.eclipse.core.databinding.observable.value.ValueDiff;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractObservableValue<T>
extends AbstractObservable
implements IObservableValue<T> {
    public AbstractObservableValue() {
        this(Realm.getDefault());
    }

    public AbstractObservableValue(Realm realm) {
        super(realm);
    }

    @Override
    public synchronized void addValueChangeListener(IValueChangeListener<? super T> listener) {
        this.addListener(ValueChangeEvent.TYPE, listener);
    }

    @Override
    public synchronized void removeValueChangeListener(IValueChangeListener<? super T> listener) {
        this.removeListener(ValueChangeEvent.TYPE, listener);
    }

    @Override
    public final void setValue(T value) {
        this.checkRealm();
        this.doSetValue(value);
    }

    protected void doSetValue(T value) {
        throw new UnsupportedOperationException();
    }

    protected void fireValueChange(ValueDiff<T> diff) {
        super.fireChange();
        this.fireEvent(new ValueChangeEvent<T>(this, diff));
    }

    @Override
    public final T getValue() {
        this.getterCalled();
        return this.doGetValue();
    }

    protected abstract T doGetValue();

    @Override
    public boolean isStale() {
        this.getterCalled();
        return false;
    }

    private void getterCalled() {
        ObservableTracker.getterCalled(this);
    }

    @Override
    protected void fireChange() {
        throw new RuntimeException("fireChange should not be called, use fireValueChange() instead");
    }

    @Override
    public Class<T> getValueClass() {
        Object valueType = this.getValueType();
        if (valueType instanceof Class) {
            return (Class)valueType;
        }
        return null;
    }
}

