/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.databinding.observable.value;

import java.util.Collection;
import java.util.Iterator;
import org.eclipse.core.databinding.observable.ChangeEvent;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.core.databinding.observable.IStaleListener;
import org.eclipse.core.databinding.observable.StaleEvent;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.value.AbstractObservableValue;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.core.databinding.observable.value.ValueDiff;
import org.eclipse.core.internal.databinding.observable.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DuplexingObservableValue<T>
extends AbstractObservableValue<T> {
    private IObservableList<T> target;
    private final Object valueType;
    private boolean dirty = true;
    private boolean updating = false;
    private T cachedValue = null;
    private IChangeListener privateChangeInterface;
    private IStaleListener privateStaleInterface;

    public static <T> DuplexingObservableValue<T> withDefaults(IObservableList<T> target, final T emptyValue, final T multiValue) {
        return new DuplexingObservableValue<T>(target){

            @Override
            protected T coalesceElements(Collection<T> elements) {
                if (elements.isEmpty()) {
                    return emptyValue;
                }
                Iterator it = elements.iterator();
                Object first = it.next();
                while (it.hasNext()) {
                    if (Util.equals(first, it.next())) continue;
                    return multiValue;
                }
                return first;
            }
        };
    }

    public DuplexingObservableValue(IObservableList<T> target) {
        this(target, target.getElementType());
    }

    public DuplexingObservableValue(IObservableList<T> target, Object valueType) {
        super(target.getRealm());
        this.target = target;
        this.valueType = valueType;
    }

    @Override
    protected void firstListenerAdded() {
        if (this.privateChangeInterface == null) {
            this.privateChangeInterface = new PrivateChangeInterface();
        }
        if (this.privateStaleInterface == null) {
            this.privateStaleInterface = new PrivateStaleInterface();
        }
        this.target.addChangeListener(this.privateChangeInterface);
        this.target.addStaleListener(this.privateStaleInterface);
    }

    @Override
    protected void lastListenerRemoved() {
        this.target.removeChangeListener(this.privateChangeInterface);
        this.target.removeStaleListener(this.privateStaleInterface);
    }

    protected final void makeDirty() {
        if (this.hasListeners() && !this.dirty) {
            this.dirty = true;
            final T oldValue = this.cachedValue;
            this.fireValueChange(new ValueDiff<T>(){

                @Override
                public T getOldValue() {
                    return oldValue;
                }

                @Override
                public T getNewValue() {
                    return DuplexingObservableValue.this.getValue();
                }
            });
        }
    }

    @Override
    public boolean isStale() {
        this.getValue();
        return this.target.isStale();
    }

    @Override
    protected T doGetValue() {
        if (!this.hasListeners()) {
            return this.coalesceElements(this.target);
        }
        if (this.dirty) {
            this.cachedValue = this.coalesceElements(this.target);
            this.dirty = false;
            if (this.target.isStale()) {
                this.fireStale();
            }
        }
        return this.cachedValue;
    }

    protected abstract T coalesceElements(Collection<T> var1);

    @Override
    protected void doSetValue(T value) {
        final T oldValue = this.cachedValue;
        boolean wasUpdating = this.updating;
        try {
            this.updating = true;
            int i = 0;
            while (i < this.target.size()) {
                this.target.set(i, value);
                ++i;
            }
        }
        finally {
            this.updating = wasUpdating;
        }
        if (this.hasListeners()) {
            this.fireValueChange(new ValueDiff<T>(){

                @Override
                public T getOldValue() {
                    return oldValue;
                }

                @Override
                public T getNewValue() {
                    return DuplexingObservableValue.this.getValue();
                }
            });
        }
    }

    @Override
    public Object getValueType() {
        return this.valueType;
    }

    @Override
    public synchronized void addChangeListener(IChangeListener listener) {
        super.addChangeListener(listener);
        this.computeValueForListeners();
    }

    @Override
    public synchronized void addValueChangeListener(IValueChangeListener<? super T> listener) {
        super.addValueChangeListener(listener);
        this.computeValueForListeners();
    }

    private void computeValueForListeners() {
        this.getRealm().exec(new Runnable(){

            public void run() {
                if (DuplexingObservableValue.this.hasListeners()) {
                    DuplexingObservableValue.this.getValue();
                }
            }
        });
    }

    @Override
    public synchronized void dispose() {
        if (this.privateChangeInterface != null && this.target != null) {
            this.target.removeChangeListener(this.privateChangeInterface);
        }
        if (this.privateStaleInterface != null && this.target != null) {
            this.target.removeStaleListener(this.privateStaleInterface);
        }
        this.target = null;
        this.privateChangeInterface = null;
        this.privateStaleInterface = null;
        super.dispose();
    }

    private class PrivateChangeInterface
    implements IChangeListener {
        private PrivateChangeInterface() {
        }

        public void handleChange(ChangeEvent event) {
            if (!DuplexingObservableValue.this.updating) {
                DuplexingObservableValue.this.makeDirty();
            }
        }
    }

    private class PrivateStaleInterface
    implements IStaleListener {
        private PrivateStaleInterface() {
        }

        public void handleStale(StaleEvent staleEvent) {
            if (!DuplexingObservableValue.this.dirty) {
                DuplexingObservableValue.this.fireStale();
            }
        }
    }
}

