/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.databinding.observable;

import java.util.Map;
import org.eclipse.core.databinding.observable.ChangeEvent;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.IStaleListener;
import org.eclipse.core.databinding.observable.StaleEvent;
import org.eclipse.core.internal.databinding.identity.IdentityMap;
import org.eclipse.core.internal.databinding.observable.IStalenessConsumer;

public class StalenessTracker {
    private Map<IObservable, Boolean> staleMap = new IdentityMap<IObservable, Boolean>();
    private int staleCount = 0;
    private final IStalenessConsumer stalenessConsumer;
    private IChangeListener childChangeListener = new ChildChangeListener();
    private IStaleListener childStaleListener = new ChildStaleListener();

    public StalenessTracker(IObservable[] observables, IStalenessConsumer stalenessConsumer) {
        this.stalenessConsumer = stalenessConsumer;
        int i = 0;
        while (i < observables.length) {
            IObservable observable = observables[i];
            this.doAddObservable(observable, false);
            ++i;
        }
        stalenessConsumer.setStale(this.staleCount > 0);
    }

    public void processStalenessChange(IObservable child, boolean callback) {
        boolean newStale;
        boolean newChildStale;
        boolean oldStale = this.staleCount > 0;
        boolean oldChildStale = this.getOldChildStale(child);
        if (oldChildStale != (newChildStale = child.isStale())) {
            this.staleCount = oldChildStale ? --this.staleCount : ++this.staleCount;
            this.staleMap.put(child, newChildStale ? Boolean.TRUE : Boolean.FALSE);
        }
        boolean bl = newStale = this.staleCount > 0;
        if (callback && newStale != oldStale) {
            this.stalenessConsumer.setStale(newStale);
        }
    }

    private boolean getOldChildStale(IObservable child) {
        Boolean oldChildValue = this.staleMap.get(child);
        boolean oldChildStale = oldChildValue == null ? false : oldChildValue;
        return oldChildStale;
    }

    public void addObservable(IObservable observable) {
        this.doAddObservable(observable, true);
    }

    private void doAddObservable(IObservable observable, boolean callback) {
        this.processStalenessChange(observable, callback);
        observable.addChangeListener(this.childChangeListener);
        observable.addStaleListener(this.childStaleListener);
    }

    public void removeObservable(IObservable observable) {
        boolean newStale;
        boolean oldStale = this.staleCount > 0;
        boolean oldChildStale = this.getOldChildStale(observable);
        if (oldChildStale) {
            --this.staleCount;
        }
        this.staleMap.remove(observable);
        observable.removeChangeListener(this.childChangeListener);
        observable.removeStaleListener(this.childStaleListener);
        boolean bl = newStale = this.staleCount > 0;
        if (newStale != oldStale) {
            this.stalenessConsumer.setStale(newStale);
        }
    }

    private class ChildChangeListener
    implements IChangeListener {
        private ChildChangeListener() {
        }

        public void handleChange(ChangeEvent event) {
            StalenessTracker.this.processStalenessChange((IObservable)event.getSource(), true);
        }
    }

    private class ChildStaleListener
    implements IStaleListener {
        private ChildStaleListener() {
        }

        public void handleStale(StaleEvent event) {
            StalenessTracker.this.processStalenessChange((IObservable)event.getSource(), true);
        }
    }
}

