/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.resources.semantic.cacheservice;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.internal.resources.semantic.cacheservice.CachedMemoryHandle;

class MemoryCache {
    private static final MemoryCache INSTANCE = new MemoryCache();
    private Map<String, CachedMemoryHandle> cacheMap = new HashMap<String, CachedMemoryHandle>();

    public static MemoryCache getInstance() {
        return INSTANCE;
    }

    private MemoryCache() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CachedMemoryHandle getOrCreateMemoryStore(String path) {
        Map<String, CachedMemoryHandle> map = this.cacheMap;
        synchronized (map) {
            CachedMemoryHandle mstore = this.cacheMap.get(path);
            if (mstore != null) {
                return mstore;
            }
            mstore = new CachedMemoryHandle(path, this);
            this.cacheMap.put(path, mstore);
            return mstore;
        }
    }

    public void removeStore(String path) {
        this.cacheMap.remove(path);
    }

    public void removeStoresRecursively(String path) {
        ArrayList<String> keysToBeRemoved = new ArrayList<String>();
        for (String storePath : this.cacheMap.keySet()) {
            if (!storePath.startsWith(path)) continue;
            keysToBeRemoved.add(storePath);
        }
        for (String string : keysToBeRemoved) {
            this.cacheMap.remove(string);
        }
    }
}

