/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.databinding.swt;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.databinding.observable.Observables;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.internal.databinding.swt.SWTDelayedObservableValueDecorator;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Scale;
import org.eclipse.swt.widgets.Slider;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SWTObservables {
    private static List<DisplayRealm> realms = new ArrayList<DisplayRealm>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Realm getRealm(Display display) {
        List<DisplayRealm> list = realms;
        synchronized (list) {
            for (DisplayRealm displayRealm : realms) {
                if (displayRealm.display != display) continue;
                return displayRealm;
            }
            DisplayRealm result = new DisplayRealm(display);
            realms.add(result);
            return result;
        }
    }

    public static <T> ISWTObservableValue<T> observeDelayedValue(int delay, ISWTObservableValue<T> observable) {
        return new SWTDelayedObservableValueDecorator(Observables.observeDelayedValue((int)delay, observable), observable.getWidget());
    }

    public static ISWTObservableValue observeEnabled(Widget widget) {
        return WidgetProperties.enabled().observe(widget);
    }

    public static ISWTObservableValue observeEnabled(Control control) {
        return SWTObservables.observeEnabled((Widget)control);
    }

    public static ISWTObservableValue observeVisible(Control control) {
        return WidgetProperties.visible().observe(control);
    }

    public static ISWTObservableValue observeTooltipText(Widget widget) {
        return WidgetProperties.tooltipText().observe(widget);
    }

    public static ISWTObservableValue observeTooltipText(Control control) {
        return SWTObservables.observeTooltipText((Widget)control);
    }

    public static ISWTObservableValue<?> observeSelection(Widget control) {
        return WidgetProperties.selection().observe(control);
    }

    public static ISWTObservableValue<?> observeSelection(Control control) {
        return WidgetProperties.selection().observe(control);
    }

    public static ISWTObservableValue<Boolean> observeSelection(Button control) {
        return WidgetProperties.selectionButton().observe(control);
    }

    public static ISWTObservableValue<String> observeSelection(Combo control) {
        return WidgetProperties.selectionCombo().observe(control);
    }

    public static ISWTObservableValue<String> observeSelection(CCombo control) {
        return WidgetProperties.selectionCCombo().observe(control);
    }

    public static ISWTObservableValue<String> observeSelection(org.eclipse.swt.widgets.List control) {
        return WidgetProperties.selectionList().observe(control);
    }

    public static ISWTObservableValue<Boolean> observeSelection(MenuItem control) {
        return WidgetProperties.selectionMenuItem().observe(control);
    }

    public static ISWTObservableValue<Integer> observeSelection(Scale control) {
        return WidgetProperties.selectionScale().observe(control);
    }

    public static ISWTObservableValue<Integer> observeSelection(Spinner control) {
        return WidgetProperties.selectionSpinner().observe(control);
    }

    public static ISWTObservableValue observeMin(Control control) {
        return WidgetProperties.minimum().observe(control);
    }

    public static ISWTObservableValue<Integer> observeMin(Scale control) {
        return WidgetProperties.minimumScale().observe(control);
    }

    public static ISWTObservableValue<Integer> observeMin(Slider control) {
        return WidgetProperties.minimumSlider().observe(control);
    }

    public static ISWTObservableValue<Integer> observeMin(Spinner control) {
        return WidgetProperties.minimumSpinner().observe(control);
    }

    public static ISWTObservableValue observeMax(Control control) {
        return WidgetProperties.maximum().observe(control);
    }

    public static ISWTObservableValue<Integer> observeMax(Scale control) {
        return WidgetProperties.maximumScale().observe(control);
    }

    public static ISWTObservableValue<Integer> observeMax(Slider control) {
        return WidgetProperties.maximumSlider().observe(control);
    }

    public static ISWTObservableValue<Integer> observeMax(Spinner control) {
        return WidgetProperties.maximumSpinner().observe(control);
    }

    public static ISWTObservableValue observeText(Control control, int[] events) {
        return WidgetProperties.text(events).observe(control);
    }

    public static ISWTObservableValue<String> observeText(Text control, int[] events) {
        return WidgetProperties.textText(events).observe(control);
    }

    public static ISWTObservableValue<String> observeText(StyledText control, int[] events) {
        return WidgetProperties.textStyledText(events).observe(control);
    }

    public static ISWTObservableValue<String> observeText(Control control, int event) {
        return WidgetProperties.text(event).observe(control);
    }

    public static ISWTObservableValue observeText(Widget widget) {
        return WidgetProperties.text().observe(widget);
    }

    public static ISWTObservableValue<String> observeText(Control control) {
        return SWTObservables.observeText((Widget)control);
    }

    public static ISWTObservableValue observeMessage(Widget widget) {
        return WidgetProperties.message().observe(widget);
    }

    public static ISWTObservableValue observeImage(Widget widget) {
        return WidgetProperties.image().observe(widget);
    }

    public static IObservableList observeItems(Control control) {
        return WidgetProperties.items().observe(control);
    }

    public static ISWTObservableValue observeSingleSelectionIndex(Control control) {
        return WidgetProperties.singleSelectionIndex().observe(control);
    }

    public static ISWTObservableValue observeForeground(Control control) {
        return WidgetProperties.foreground().observe(control);
    }

    public static ISWTObservableValue observeBackground(Control control) {
        return WidgetProperties.background().observe(control);
    }

    public static ISWTObservableValue observeFont(Control control) {
        return WidgetProperties.font().observe(control);
    }

    public static ISWTObservableValue observeSize(Control control) {
        return WidgetProperties.size().observe(control);
    }

    public static ISWTObservableValue observeLocation(Control control) {
        return WidgetProperties.location().observe(control);
    }

    public static ISWTObservableValue observeFocus(Control control) {
        return WidgetProperties.focused().observe(control);
    }

    public static ISWTObservableValue observeBounds(Control control) {
        return WidgetProperties.bounds().observe(control);
    }

    public static ISWTObservableValue observeEditable(Control control) {
        return WidgetProperties.editable().observe(control);
    }

    private static class DisplayRealm
    extends Realm {
        private Display display;

        private DisplayRealm(Display display) {
            this.display = display;
        }

        public boolean isCurrent() {
            return Display.getCurrent() == this.display;
        }

        public void asyncExec(final Runnable runnable) {
            Runnable safeRunnable = new Runnable(){

                public void run() {
                    DisplayRealm.safeRun((Runnable)runnable);
                }
            };
            if (!this.display.isDisposed()) {
                this.display.asyncExec(safeRunnable);
            }
        }

        public void timerExec(int milliseconds, final Runnable runnable) {
            if (!this.display.isDisposed()) {
                Runnable safeRunnable = new Runnable(){

                    public void run() {
                        DisplayRealm.safeRun((Runnable)runnable);
                    }
                };
                this.display.timerExec(milliseconds, safeRunnable);
            }
        }

        public int hashCode() {
            return this.display == null ? 0 : this.display.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (((Object)((Object)this)).getClass() != obj.getClass()) {
                return false;
            }
            DisplayRealm other = (DisplayRealm)((Object)obj);
            return !(this.display == null ? other.display != null : !this.display.equals(other.display));
        }
    }
}

