/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.platform.discovery.testutils.utils.registry;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.platform.discovery.destprefs.api.ISearchDestinationConfigurator;
import org.eclipse.platform.discovery.runtime.api.IDestinationsProvider;
import org.eclipse.platform.discovery.runtime.api.ISearchDestination;
import org.eclipse.platform.discovery.runtime.api.ISearchProvider;
import org.eclipse.platform.discovery.runtime.api.persistence.IMementoLoadProvider;
import org.eclipse.platform.discovery.runtime.api.persistence.IMementoStoreProvider;
import org.eclipse.platform.discovery.ui.api.IAdvancedSearchParamsUiContributor;
import org.eclipse.platform.discovery.ui.api.ISearchResultCustomUiCreator;
import org.eclipse.platform.discovery.util.internal.StatusUtils;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.osgi.framework.FrameworkUtil;

public class ExtensionRegistryBuilder {
    private IExtensionRegistry extensionRegistry;
    private IExtensionPoint objectTypesExtensionPoint;
    private IExtensionPoint destinationProvidersExtensionPoint;
    private IExtensionPoint destinationCategoriesExtensionPoint;
    private IExtensionPoint loadProvidersExtensionPoint;
    private IExtensionPoint storeProvidersExtensionPoint;
    private IExtensionPoint searchProvidersExtensionPoint;
    private IExtensionPoint searchSubdestinationsExtensionPoint;
    private IExtensionPoint advancedSearchUiContributorsExtensionPoint;
    private IExtensionPoint customResultUiContributorsExtensionPoint;
    private IExtensionPoint searchDestinationsConfiguratorExtensionPoint;
    private List<IConfigurationElement> objectTypes = new ArrayList<IConfigurationElement>();
    private List<IConfigurationElement> destinationProviders = new ArrayList<IConfigurationElement>();
    private List<IConfigurationElement> destinationCategories = new ArrayList<IConfigurationElement>();
    private List<IConfigurationElement> loadProviders = new ArrayList<IConfigurationElement>();
    private List<IConfigurationElement> storeProviders = new ArrayList<IConfigurationElement>();
    private List<IConfigurationElement> searchProviders = new ArrayList<IConfigurationElement>();
    private List<IConfigurationElement> searchSubdestinations = new ArrayList<IConfigurationElement>();
    private List<IConfigurationElement> advancedSearchUiContributors = new ArrayList<IConfigurationElement>();
    private List<IConfigurationElement> customResultUiContributors = new ArrayList<IConfigurationElement>();
    private List<IConfigurationElement> searchDestinationConfigurators = new ArrayList<IConfigurationElement>();

    public ExtensionRegistryBuilder() {
        this.extensionRegistry = (IExtensionRegistry)Mockito.mock(IExtensionRegistry.class, (String)"extension registry");
        this.objectTypesExtensionPoint = this.setupExtensionPoint("org.eclipse.platform.discovery.runtime.objecttype");
        this.destinationProvidersExtensionPoint = this.setupExtensionPoint("org.eclipse.platform.discovery.runtime.destinationsprovider");
        this.destinationCategoriesExtensionPoint = this.setupExtensionPoint("org.eclipse.platform.discovery.runtime.destinationcategory");
        this.loadProvidersExtensionPoint = this.setupExtensionPoint("org.eclipse.platform.discovery.integration.persistence.mementoloadprovider");
        this.storeProvidersExtensionPoint = this.setupExtensionPoint("org.eclipse.platform.discovery.integration.persistence.mementostoreprovider");
        this.searchProvidersExtensionPoint = this.setupExtensionPoint("org.eclipse.platform.discovery.runtime.searchprovider");
        this.searchSubdestinationsExtensionPoint = this.setupExtensionPoint("org.eclipse.platform.discovery.runtime.searchsubdestinations");
        this.advancedSearchUiContributorsExtensionPoint = this.setupExtensionPoint("org.eclipse.platform.discovery.ui.advancedsearchparams");
        this.customResultUiContributorsExtensionPoint = this.setupExtensionPoint("org.eclipse.platform.discovery.ui.customresultui");
        this.searchDestinationsConfiguratorExtensionPoint = this.setupExtensionPoint("org.eclipse.platform.discovery.destprefs.configurator");
    }

    protected IExtensionPoint setupExtensionPoint(String xpId) {
        IExtensionPoint point = (IExtensionPoint)Mockito.mock(IExtensionPoint.class, (String)("extension point for" + xpId));
        Mockito.when((Object)this.extensionRegistry.getExtensionPoint((String)Matchers.eq((Object)xpId))).thenReturn((Object)point);
        return point;
    }

    public void addObjectType(String id, String displayName) {
        IConfigurationElement element = this.createConfigurationElement("objecttype");
        this.setAttribute(element, "id", id);
        this.setAttribute(element, "displayname", displayName);
        this.objectTypes.add(element);
    }

    public void addDestinationsProvider(String providerId, String destinationCategory, String preferencePageId, String providerInstanceFqName, IDestinationsProvider providerInstance) {
        IConfigurationElement element = this.createConfigurationElement("destinationsprovider");
        this.setAttribute(element, "id", providerId);
        this.setAttribute(element, "destcategoryid", destinationCategory);
        this.setAttribute(element, "preferencepageid", preferencePageId);
        this.setAttribute(element, "provider", providerInstanceFqName);
        this.setExecutableExtension(element, providerInstance, "provider");
        this.destinationProviders.add(element);
    }

    protected void setExecutableExtension(IConfigurationElement element, Object objectToReturn, String classAttributeName) {
        try {
            Mockito.when((Object)element.createExecutableExtension(classAttributeName)).thenReturn(objectToReturn);
        }
        catch (CoreException e) {
            throw new RuntimeException(e);
        }
    }

    protected void setAttribute(IConfigurationElement element, String attributeName, String attributeValue) {
        Mockito.when((Object)element.getAttribute(attributeName)).thenReturn((Object)attributeValue);
    }

    protected IConfigurationElement createConfigurationElement(String elementName) {
        IConfigurationElement element = (IConfigurationElement)Mockito.mock(IConfigurationElement.class);
        Mockito.when((Object)element.getName()).thenReturn((Object)elementName);
        return element;
    }

    public void addDestinationCategory(String categoryId, String categoryName, Class<? extends ISearchDestination> destinationsClass) {
        IConfigurationElement element = this.createConfigurationElement("destinationcategory");
        this.setAttribute(element, "id", categoryId);
        this.setAttribute(element, "displayname", categoryName);
        if (destinationsClass != null) {
            String bundleSymbolicName = FrameworkUtil.getBundle(destinationsClass).getSymbolicName();
            this.setNamespaceIdentifier(element, bundleSymbolicName);
            this.setAttribute(element, "destinationclass", destinationsClass.getName());
        }
        this.destinationCategories.add(element);
    }

    public void addDestinationCategory(String categoryId, String categoryName) {
        this.addDestinationCategory(categoryId, categoryName, null);
    }

    private void setNamespaceIdentifier(IConfigurationElement element, String bundleSymbolicName) {
        Mockito.when((Object)element.getNamespaceIdentifier()).thenReturn((Object)bundleSymbolicName);
    }

    public void addMementoLoadProvider(IMementoLoadProvider loadProvider) {
        IConfigurationElement loadProviderElement = this.createConfigurationElement("provider");
        this.setExecutableExtension(loadProviderElement, loadProvider, "class");
        this.loadProviders.add(loadProviderElement);
    }

    public void addMementoStoreProvider(IMementoStoreProvider storeProvider) {
        IConfigurationElement storeProviderElement = this.createConfigurationElement("provider");
        this.setExecutableExtension(storeProviderElement, storeProvider, "class");
        this.storeProviders.add(storeProviderElement);
    }

    public void addSearchProvider(String providerId, String providerFqName, ISearchProvider searchProviderMock, String objectTypeId, String providerSupportsTextSearch, String ... supportedCategoryIds) {
        IConfigurationElement searchProviderElement = this.createConfigurationElement("searchprovider");
        this.setAttribute(searchProviderElement, "id", providerId);
        this.setAttribute(searchProviderElement, "instance", providerFqName);
        this.setAttribute(searchProviderElement, "id", providerId);
        this.setExecutableExtension(searchProviderElement, searchProviderMock, "instance");
        this.setAttribute(searchProviderElement, "objecttypeid", objectTypeId);
        this.setAttribute(searchProviderElement, "supportstextsearch", providerSupportsTextSearch);
        ArrayList<IConfigurationElement> categoriesList = new ArrayList<IConfigurationElement>();
        String[] stringArray = supportedCategoryIds;
        int n = supportedCategoryIds.length;
        int n2 = 0;
        while (n2 < n) {
            String categoryId = stringArray[n2];
            IConfigurationElement categoryElement = (IConfigurationElement)Mockito.mock(IConfigurationElement.class);
            this.setAttribute(categoryElement, "categoryid", categoryId);
            categoriesList.add(categoryElement);
            ++n2;
        }
        this.setChildren(searchProviderElement, categoriesList, "category");
        this.searchProviders.add(searchProviderElement);
    }

    private void setChildren(IConfigurationElement element, List<IConfigurationElement> children, String childrenElementsName) {
        Mockito.when((Object)element.getChildren(childrenElementsName)).thenReturn((Object)children.toArray(new IConfigurationElement[0]));
    }

    public void addSearchSubdestination(String id, String displayName, String categoryId, String objectTypeId, String defaultSelected, String ... conflicts) {
        IConfigurationElement subdestinationElement = this.createConfigurationElement("subdestination");
        this.setAttribute(subdestinationElement, "id", id);
        this.setAttribute(subdestinationElement, "displayname", displayName);
        this.setAttribute(subdestinationElement, "categoryid", categoryId);
        this.setAttribute(subdestinationElement, "objecttypeid", objectTypeId);
        this.setAttribute(subdestinationElement, "defaultSelected", defaultSelected);
        ArrayList<IConfigurationElement> conflictsList = new ArrayList<IConfigurationElement>();
        String[] stringArray = conflicts;
        int n = conflicts.length;
        int n2 = 0;
        while (n2 < n) {
            String conflictId = stringArray[n2];
            IConfigurationElement conflictElement = (IConfigurationElement)Mockito.mock(IConfigurationElement.class);
            this.setAttribute(conflictElement, "conflictingSubdID", conflictId);
            conflictsList.add(conflictElement);
            ++n2;
        }
        this.setChildren(subdestinationElement, conflictsList, "conflict");
        this.searchSubdestinations.add(subdestinationElement);
    }

    public void addAdvancedSearchParamsUiContributor(String id, String searchProviderId, String contributorFQName, IAdvancedSearchParamsUiContributor contributorInstance) {
        IConfigurationElement advancedUiContributorElement = this.createAdvancedParamsUiElement(id, searchProviderId, contributorFQName);
        this.setExecutableExtension(advancedUiContributorElement, contributorInstance, "uicontributorclass");
        this.advancedSearchUiContributors.add(advancedUiContributorElement);
    }

    private IConfigurationElement createAdvancedParamsUiElement(String id, String searchProviderId, String contributorFQName) {
        IConfigurationElement advancedUiContributorElement = this.createConfigurationElement("advancedsearchparams");
        this.setAttribute(advancedUiContributorElement, "id", id);
        this.setAttribute(advancedUiContributorElement, "searchproviderid", searchProviderId);
        this.setAttribute(advancedUiContributorElement, "uicontributorclass", contributorFQName);
        return advancedUiContributorElement;
    }

    public void addExceptionThrowingAdvancedSearchParamsUiContributor(String id, String searchProviderId, String contributorFQName) {
        IConfigurationElement advancedUiContributorElement = this.createAdvancedParamsUiElement(id, searchProviderId, contributorFQName);
        this.setupCreateExecutableExtensionToThrowException(advancedUiContributorElement, "uicontributorclass");
        this.advancedSearchUiContributors.add(advancedUiContributorElement);
    }

    protected void setupCreateExecutableExtensionToThrowException(IConfigurationElement element, String classAttributeName) {
        this.setupCreateExecutableExtensionToThrowException(element, classAttributeName, new CoreException(StatusUtils.statusError((String)"TEST")));
    }

    protected void setupCreateExecutableExtensionToThrowException(IConfigurationElement element, String classAttributeName, CoreException toThrow) {
        try {
            Mockito.when((Object)element.createExecutableExtension(classAttributeName)).thenThrow(new Throwable[]{toThrow});
        }
        catch (CoreException e) {
            throw new RuntimeException(e);
        }
    }

    public void addCustomResultUiContributor(String id, String searchProviderId, String contributorFQName, ISearchResultCustomUiCreator cobntributorInstance) {
        IConfigurationElement customResultUiElement = this.createCustomResultUIElement(id, searchProviderId, contributorFQName);
        this.setExecutableExtension(customResultUiElement, cobntributorInstance, "creator");
        this.customResultUiContributors.add(customResultUiElement);
    }

    private IConfigurationElement createCustomResultUIElement(String id, String searchProviderId, String contributorFQName) {
        IConfigurationElement customResultUiElement = this.createConfigurationElement("contributor");
        this.setAttribute(customResultUiElement, "id", id);
        this.setAttribute(customResultUiElement, "searchproviderid", searchProviderId);
        this.setAttribute(customResultUiElement, "creator", contributorFQName);
        return customResultUiElement;
    }

    public void addExceptionThrowingCustomResultUiContributor(String id, String searchProviderId, String contributorFQName) {
        IConfigurationElement customResultUiElement = this.createCustomResultUIElement(id, searchProviderId, contributorFQName);
        this.setupCreateExecutableExtensionToThrowException(customResultUiElement, "creator");
        this.customResultUiContributors.add(customResultUiElement);
    }

    public IExtensionRegistry getRegistry() {
        this.setupExtensionPointConfigElements();
        this.clearState();
        return this.extensionRegistry;
    }

    public void addSearchDestinationsConfigurator(String id, String destinationProviderId, String configuratorFQName, ISearchDestinationConfigurator<?> configuratorInstance) {
        this.searchDestinationConfigurators.add(this.createSearchDestinationsConfiguratorElement(id, destinationProviderId, configuratorFQName, configuratorInstance));
    }

    private IConfigurationElement createSearchDestinationsConfiguratorElement(String id, String destinationProviderId, String configuratorFQName, ISearchDestinationConfigurator<?> configuratorInstance) {
        try {
            IConfigurationElement element = this.createConfigurationElement("destinationConfigurator");
            this.setAttribute(element, "id", id);
            this.setAttribute(element, "destProviderId", destinationProviderId);
            this.setAttribute(element, "contributorClass", configuratorFQName);
            Mockito.when((Object)element.createExecutableExtension((String)Matchers.eq((Object)"contributorClass"))).thenReturn(configuratorInstance);
            return element;
        }
        catch (CoreException ex) {
            throw new IllegalStateException(ex);
        }
    }

    protected void setupExtensionPointConfigElements() {
        Mockito.when((Object)this.objectTypesExtensionPoint.getConfigurationElements()).thenReturn((Object)this.objectTypes.toArray(new IConfigurationElement[0]));
        Mockito.when((Object)this.destinationProvidersExtensionPoint.getConfigurationElements()).thenReturn((Object)this.destinationProviders.toArray(new IConfigurationElement[0]));
        Mockito.when((Object)this.destinationCategoriesExtensionPoint.getConfigurationElements()).thenReturn((Object)this.destinationCategories.toArray(new IConfigurationElement[0]));
        Mockito.when((Object)this.loadProvidersExtensionPoint.getConfigurationElements()).thenReturn((Object)this.loadProviders.toArray(new IConfigurationElement[0]));
        Mockito.when((Object)this.storeProvidersExtensionPoint.getConfigurationElements()).thenReturn((Object)this.storeProviders.toArray(new IConfigurationElement[0]));
        Mockito.when((Object)this.searchProvidersExtensionPoint.getConfigurationElements()).thenReturn((Object)this.searchProviders.toArray(new IConfigurationElement[0]));
        Mockito.when((Object)this.searchSubdestinationsExtensionPoint.getConfigurationElements()).thenReturn((Object)this.searchSubdestinations.toArray(new IConfigurationElement[0]));
        Mockito.when((Object)this.advancedSearchUiContributorsExtensionPoint.getConfigurationElements()).thenReturn((Object)this.advancedSearchUiContributors.toArray(new IConfigurationElement[0]));
        Mockito.when((Object)this.customResultUiContributorsExtensionPoint.getConfigurationElements()).thenReturn((Object)this.customResultUiContributors.toArray(new IConfigurationElement[0]));
        Mockito.when((Object)this.searchDestinationsConfiguratorExtensionPoint.getConfigurationElements()).thenReturn((Object)this.searchDestinationConfigurators.toArray(new IConfigurationElement[0]));
    }

    protected void clearState() {
        List[] listArray = new List[]{this.objectTypes, this.destinationProviders, this.destinationCategories, this.loadProviders, this.storeProviders, this.searchProviders, this.searchSubdestinations, this.advancedSearchUiContributors, this.customResultUiContributors, this.searchDestinationConfigurators};
        int n = listArray.length;
        int n2 = 0;
        while (n2 < n) {
            List list = listArray[n2];
            list.clear();
            ++n2;
        }
    }
}

