/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.platform.discovery.ui.test.comp.internal;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import junit.framework.Assert;
import org.eclipse.platform.discovery.runtime.api.GroupingHierarchy;
import org.eclipse.platform.discovery.runtime.api.ISearchDestination;
import org.eclipse.platform.discovery.runtime.api.ISearchParameters;
import org.eclipse.platform.discovery.runtime.internal.model.descriptions.IObjectTypeDescription;
import org.eclipse.platform.discovery.ui.api.IAdvancedSearchParamsUiContributor;
import org.eclipse.platform.discovery.ui.api.IViewUiContext;
import org.eclipse.platform.discovery.ui.internal.plugin.DiscoveryUIMessages;
import org.eclipse.platform.discovery.ui.internal.search.advancedparams.IAdvancedSearchParamsUiContributorDescr;
import org.eclipse.platform.discovery.ui.internal.view.impl.SearchParameters;
import org.eclipse.platform.discovery.ui.internal.xp.IAdvancedSearchParamsUiContribXpParser;
import org.eclipse.platform.discovery.ui.test.comp.internal.fixture.SearchConsoleTestFixture;
import org.eclipse.platform.discovery.ui.test.comp.internal.pageobjects.AdvancedSearchParamsPageObject;
import org.eclipse.platform.discovery.util.api.env.IDiscoveryEnvironment;
import org.eclipse.platform.discovery.util.internal.property.IPropertyAttributeListener;
import org.eclipse.platform.discovery.util.internal.property.PropertyAttributeChangedEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

public class AdvancedSearchParamsDisplayerTest {
    private static final String TEST_BUTTON_TEXT = "Custom B";
    private static final Object CUSTOM_SEARCH_PARAM_ID_1 = new Object();
    private static final Object CUSTOM_SEARCH_PARAM_ID_2 = new Object();
    private static final Object CUSTOM_SEARCH_PARAM_VALUE_1 = new Object();
    private static final Object CUSTOM_SEARCH_PARAM_VALUE_2 = new Object();
    private static SearchConsoleTestFixture fixture;
    private MyUiContributor searchParamsUiContributor;
    private AdvancedSearchParamsPageObject<Button> paramsPageObject;
    @Mock
    private IAdvancedSearchParamsUiContributorDescr searchParamsUiContribDescr;
    @Mock
    private IAdvancedSearchParamsUiContribXpParser xpParser;

    @BeforeClass
    public static void initFixture() {
        fixture = new SearchConsoleTestFixture();
    }

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        this.setupUiContributors();
        this.setupXpParser();
        this.paramsPageObject = new AdvancedSearchParamsPageObject<Button>(AdvancedSearchParamsDisplayerTest.fixture.searchProviderConfiguration, this.xpParser, this.searchParamsUiContributor.buttonMatcher());
        this.paramsPageObject.open();
    }

    @After
    public void tearDown() {
        this.paramsPageObject.close();
    }

    private void setupUiContributors() {
        this.searchParamsUiContributor = new MyUiContributor();
        String searchProviderId = AdvancedSearchParamsDisplayerTest.fixture.unsupportingTextSearchProviderDescription.getId();
        Mockito.stub((Object)this.searchParamsUiContribDescr.getSearchProviderId()).toReturn((Object)searchProviderId);
        Mockito.stub((Object)this.searchParamsUiContribDescr.createContributor()).toReturn((Object)this.searchParamsUiContributor);
    }

    private void setupXpParser() {
        Mockito.stub((Object)this.xpParser.readContributions()).toReturn(Arrays.asList(this.searchParamsUiContribDescr));
    }

    @Test
    public void testUiIsCreatedOnUpdatingDisplayer() {
        this.setInput(AdvancedSearchParamsDisplayerTest.fixture.objectType1, AdvancedSearchParamsDisplayerTest.fixture.destination1);
        Assert.assertSame((String)"Unexpected UI contributor", (Object)this.searchParamsUiContributor, (Object)this.paramsPageObject.getUiContributor());
        Assert.assertEquals((String)"One UI creation expected", (int)1, (int)this.searchParamsUiContributor.createdUiCount);
    }

    @Test
    public void testOldSearchParametersCompositeIsDisposedOnUpdate() {
        this.setInput(AdvancedSearchParamsDisplayerTest.fixture.objectType1, AdvancedSearchParamsDisplayerTest.fixture.destination1);
        Composite firstComposite = this.paramsPageObject.getParametersComposite();
        this.setInput(AdvancedSearchParamsDisplayerTest.fixture.objectType1, AdvancedSearchParamsDisplayerTest.fixture.destination1);
        Composite secondComposite = this.paramsPageObject.getParametersComposite();
        Assert.assertEquals((String)"Two UI creations expected", (int)2, (int)this.searchParamsUiContributor.createdUiCount);
        Assert.assertNotNull((Object)firstComposite);
        Assert.assertNotNull((Object)secondComposite);
        Assert.assertTrue((String)"First params composite was not disposed", (boolean)firstComposite.isDisposed());
        Assert.assertTrue((String)"Params composite was not recreated", (firstComposite != secondComposite ? 1 : 0) != 0);
    }

    @Test
    public void testSectionIsDisposedNoDestinationSpecified() {
        this.setInput(AdvancedSearchParamsDisplayerTest.fixture.objectType1, AdvancedSearchParamsDisplayerTest.fixture.destination1);
        Composite initialParametersComposite = this.paramsPageObject.getParametersComposite();
        Composite initialParametersCompositeParent = this.paramsPageObject.getParametersCompositeParent();
        this.setInput(AdvancedSearchParamsDisplayerTest.fixture.objectType1, null);
        Assert.assertNull((String)"No contributor expected when no UI displayed", (Object)this.paramsPageObject.getUiContributor());
        Assert.assertFalse((String)"Section unexpectedly displayed", (boolean)this.paramsPageObject.isSectionVisible());
        Assert.assertTrue((String)"Containing composite is not disposed", (boolean)initialParametersComposite.isDisposed());
        Assert.assertTrue((String)"Section is not disposed", (boolean)initialParametersCompositeParent.isDisposed());
    }

    @Test
    public void testCustomUIIsDisplayedByDefault() {
        this.setInput(AdvancedSearchParamsDisplayerTest.fixture.objectType1, AdvancedSearchParamsDisplayerTest.fixture.destination1);
        Assert.assertTrue((String)"Custom UI not available", (boolean)this.paramsPageObject.isCustomUiAvailable());
    }

    @Test
    public void testCustomUIHidesWhenNoCustomUi() {
        this.setInput(AdvancedSearchParamsDisplayerTest.fixture.objectType1, AdvancedSearchParamsDisplayerTest.fixture.destination1);
        this.setInput(AdvancedSearchParamsDisplayerTest.fixture.objectType2, AdvancedSearchParamsDisplayerTest.fixture.destination3);
        Assert.assertFalse((String)"Custom UI unexpectedly available", (boolean)this.paramsPageObject.isCustomUiAvailable());
    }

    @Test
    public void testSectionTitleChanges() {
        this.setInput(AdvancedSearchParamsDisplayerTest.fixture.objectType1, AdvancedSearchParamsDisplayerTest.fixture.destination1);
        Assert.assertEquals((String)"Unexpected section title", (String)DiscoveryUIMessages.CUSTOM_PARAMS_SECTION_EXPAND_TITLE, (String)this.paramsPageObject.getSectionTitle());
        this.paramsPageObject.showCustomUi();
        Assert.assertEquals((String)"Unexpected section title", (String)DiscoveryUIMessages.CUSTOM_PARAMS_SECTION_COLAPSE_TITLE, (String)this.paramsPageObject.getSectionTitle());
        this.paramsPageObject.hideCustomUi();
        Assert.assertEquals((String)"Unexpected section title", (String)DiscoveryUIMessages.CUSTOM_PARAMS_SECTION_EXPAND_TITLE, (String)this.paramsPageObject.getSectionTitle());
    }

    @Test
    public void testVisibilityIsHandledByCustomUI() {
        this.setInput(AdvancedSearchParamsDisplayerTest.fixture.objectType1, AdvancedSearchParamsDisplayerTest.fixture.destination1);
        Assert.assertFalse((String)"Custom UI shown right after setting input", (boolean)this.searchParamsUiContributor.visible);
        this.paramsPageObject.showCustomUi();
        Assert.assertTrue((String)"Custom UI is not shown", (boolean)this.searchParamsUiContributor.visible);
        this.paramsPageObject.hideCustomUi();
        Assert.assertFalse((String)"Custom UI is still visible", (boolean)this.searchParamsUiContributor.visible);
    }

    @Test
    public void testSetEnabled() {
        this.setInput(AdvancedSearchParamsDisplayerTest.fixture.objectType1, AdvancedSearchParamsDisplayerTest.fixture.destination1);
        this.paramsPageObject.showCustomUi();
        this.paramsPageObject.disable();
        Assert.assertFalse((String)"Section should be not available when displayer disabled", (boolean)this.paramsPageObject.isSectionVisible());
        this.paramsPageObject.enable();
        Assert.assertTrue((String)"Section should be visible when displayer enabled", (boolean)this.paramsPageObject.isSectionVisible());
    }

    @Test
    public void testUpdateSearchParametersWithCustomParams() {
        this.setInput(AdvancedSearchParamsDisplayerTest.fixture.objectType1, AdvancedSearchParamsDisplayerTest.fixture.destination1);
        ISearchDestination searchDestination = (ISearchDestination)Mockito.mock(ISearchDestination.class);
        SearchParameters searchParams = new SearchParameters("a", searchDestination, "A", new GroupingHierarchy("A", (Object)"A"), new HashSet());
        this.paramsPageObject.setParams((ISearchParameters)searchParams);
        Map customParams = searchParams.getCustomParameters();
        Assert.assertEquals((String)"Two custom parameters expected", (int)2, (int)customParams.size());
        Assert.assertTrue((String)"Unexpected custom parameter", (customParams.get(CUSTOM_SEARCH_PARAM_ID_1) == CUSTOM_SEARCH_PARAM_VALUE_1 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Unexpected custom parameter", (customParams.get(CUSTOM_SEARCH_PARAM_ID_2) == CUSTOM_SEARCH_PARAM_VALUE_2 ? 1 : 0) != 0);
    }

    @Test
    public void testSectionExapndNotifiesResizeListener() {
        final Point[] oldSectionSize = new Point[1];
        final Point[] newSectionSize = new Point[1];
        this.setInput(AdvancedSearchParamsDisplayerTest.fixture.objectType1, AdvancedSearchParamsDisplayerTest.fixture.destination1);
        this.paramsPageObject.registerSizePropertyChangeListener(new IPropertyAttributeListener<Point>(){

            public void attributeChanged(PropertyAttributeChangedEvent<Point> event) {
                oldSectionSize[0] = (Point)event.getOldAttribute();
                newSectionSize[0] = (Point)event.getNewAttribute();
            }
        }, true);
        Assert.assertNotNull((String)"Listener not notified upon registration", (Object)newSectionSize[0]);
        Assert.assertTrue((String)"Listener not notified upon registration", (newSectionSize[0].y > 0 ? 1 : 0) != 0);
        this.paramsPageObject.showCustomUi();
        Assert.assertNotNull((String)"Listener not notified upon expanding the section", (Object)oldSectionSize[0]);
        Assert.assertTrue((String)"Listener not notified upon expanding the section", (newSectionSize[0].y > oldSectionSize[0].y ? 1 : 0) != 0);
        this.paramsPageObject.hideCustomUi();
        Assert.assertTrue((String)"Listener not notified upon collapsing the section", (newSectionSize[0].y < oldSectionSize[0].y ? 1 : 0) != 0);
    }

    private void setInput(IObjectTypeDescription objectType, ISearchDestination destination) {
        this.paramsPageObject.setInput(objectType, destination, AdvancedSearchParamsDisplayerTest.fixture.environment, AdvancedSearchParamsDisplayerTest.fixture.viewUiContext);
    }

    private class MyUiContributor
    implements IAdvancedSearchParamsUiContributor {
        public int createdUiCount = 0;
        public boolean visible = false;

        private MyUiContributor() {
        }

        public void createUi(Composite parent, ISearchDestination searchDestination, FormToolkit formToolkit, IDiscoveryEnvironment env, IViewUiContext uiContext) {
            ++this.createdUiCount;
            Button b = formToolkit.createButton(parent, AdvancedSearchParamsDisplayerTest.TEST_BUTTON_TEXT, 8);
            b.setLayoutData((Object)this.fillingFormData());
        }

        public Map<Object, Object> getParameters() {
            HashMap<Object, Object> result = new HashMap<Object, Object>();
            result.put(CUSTOM_SEARCH_PARAM_ID_1, CUSTOM_SEARCH_PARAM_VALUE_1);
            result.put(CUSTOM_SEARCH_PARAM_ID_2, CUSTOM_SEARCH_PARAM_VALUE_2);
            return result;
        }

        public void handleVisibilityChange(boolean visible) {
            this.visible = visible;
        }

        public void setEnabled(boolean enable) {
        }

        private FormData fillingFormData() {
            FormData fd = new FormData();
            fd.top = new FormAttachment(0, 0);
            fd.left = new FormAttachment(0, 0);
            fd.right = new FormAttachment(100, 0);
            return fd;
        }

        Matcher<Button> buttonMatcher() {
            return new BaseMatcher<Button>(){

                public boolean matches(Object item) {
                    if (item instanceof Button) {
                        String buttonText = ((Button)item).getText();
                        return AdvancedSearchParamsDisplayerTest.TEST_BUTTON_TEXT.equals(buttonText);
                    }
                    return false;
                }

                public void describeTo(Description description) {
                }
            };
        }
    }
}

