/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.platform.discovery.ui.test.comp.internal;

import java.text.MessageFormat;
import java.util.Collection;
import junit.framework.Assert;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.platform.discovery.core.api.ISearchContext;
import org.eclipse.platform.discovery.core.internal.ISearchSession;
import org.eclipse.platform.discovery.runtime.api.ISearchDestination;
import org.eclipse.platform.discovery.runtime.api.ISearchParameters;
import org.eclipse.platform.discovery.runtime.internal.model.descriptions.IDestinationCategoryDescription;
import org.eclipse.platform.discovery.runtime.internal.model.descriptions.IObjectTypeDescription;
import org.eclipse.platform.discovery.ui.api.IGenericViewCustomization;
import org.eclipse.platform.discovery.ui.api.IViewUiContext;
import org.eclipse.platform.discovery.ui.internal.plugin.DiscoveryUIMessages;
import org.eclipse.platform.discovery.ui.internal.search.advancedparams.IAdvancedSearchParamsDisplayer;
import org.eclipse.platform.discovery.ui.internal.view.impl.ITabbedSessionDisplayer;
import org.eclipse.platform.discovery.ui.internal.view.impl.SearchConsoleSelectionProvider;
import org.eclipse.platform.discovery.ui.test.comp.internal.fixture.SearchConsoleTestFixture;
import org.eclipse.platform.discovery.ui.test.comp.internal.pageobjects.SearchConsolePageObject;
import org.eclipse.platform.discovery.util.internal.session.ISession;
import org.eclipse.ui.IWorkbenchPartSite;
import org.junit.After;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;

public class SearchConsoleViewTest {
    private SearchConsolePageObject consolePageObject;
    private static SearchConsoleTestFixture fixture;
    @Mock
    private IAdvancedSearchParamsDisplayer searchParamsDisplayer;
    private static final String KEYWORD_SEARCH_PARAMETER = "my keyword param";
    private static final String testSessionId = "testsessionid";
    protected ITabbedSessionDisplayer<ISearchContext> sessionDisplayer;
    protected IViewUiContext uiContext;

    @BeforeClass
    public static void initFixture() {
        fixture = new SearchConsoleTestFixture();
    }

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        this.sessionDisplayer = (ITabbedSessionDisplayer)Mockito.mock(ITabbedSessionDisplayer.class);
        this.searchParamsDisplayer = (IAdvancedSearchParamsDisplayer)Mockito.mock(IAdvancedSearchParamsDisplayer.class);
        this.consolePageObject = new SearchConsolePageObject(SearchConsoleViewTest.fixture.searchProviderConfiguration, this.sessionDisplayer, this.searchParamsDisplayer, SearchConsoleViewTest.fixture.environment, SearchConsoleViewTest.fixture.viewUiContext);
        this.consolePageObject.open();
    }

    @After
    public void tearDown() {
        this.consolePageObject.close();
    }

    @Test
    public void testSelectingObjectsChangesDestinations() {
        Assert.assertNull((String)"No objects selected expected by default", (Object)this.consolePageObject.getSelectedObject());
        Assert.assertEquals((String)"No destination categories expected to be visible by default", (int)0, (int)this.consolePageObject.getCategories().size());
        this.selectObject(SearchConsoleViewTest.fixture.objectType1);
        this.consolePageObject.expandDestinations();
        this.assertSingleCategoryVisible(SearchConsoleViewTest.fixture.category1);
        this.assertDestinationsVisible(SearchConsoleViewTest.fixture.category1, SearchConsoleViewTest.fixture.destination1, SearchConsoleViewTest.fixture.destination2);
        this.selectObject(SearchConsoleViewTest.fixture.objectType2);
        this.consolePageObject.expandDestinations();
        this.assertSingleCategoryVisible(SearchConsoleViewTest.fixture.category2);
        this.assertDestinationsVisible(SearchConsoleViewTest.fixture.category2, SearchConsoleViewTest.fixture.destination3, SearchConsoleViewTest.fixture.destination4);
    }

    private void assertDestinationsVisible(IDestinationCategoryDescription category, ISearchDestination ... expectedDestinations) {
        Collection<String> visibleDestinations = this.consolePageObject.getDestinationsForCategory(category.getDisplayName());
        Assert.assertEquals((String)MessageFormat.format("Unexpected destinations caount for category {0}", category.getDisplayName()), (int)expectedDestinations.length, (int)visibleDestinations.size());
        ISearchDestination[] iSearchDestinationArray = expectedDestinations;
        int n = expectedDestinations.length;
        int n2 = 0;
        while (n2 < n) {
            ISearchDestination expectedDest = iSearchDestinationArray[n2];
            Assert.assertTrue((String)MessageFormat.format("Destination {0} not visible", expectedDest.getDisplayName()), (boolean)visibleDestinations.contains(expectedDest.getDisplayName()));
            ++n2;
        }
    }

    private void assertSingleCategoryVisible(IDestinationCategoryDescription category) {
        Collection<String> visibleCategories = this.consolePageObject.getCategories();
        Assert.assertTrue((String)MessageFormat.format("Category {0} not available", category.getDisplayName()), (boolean)visibleCategories.contains(category.getDisplayName()));
        Assert.assertEquals((String)"Expected to display exactly one category", (int)1, (int)visibleCategories.size());
    }

    @Test
    public void testSelectingObjectsNotifiesAdvancedParametersComponent() {
        this.selectObject(SearchConsoleViewTest.fixture.objectType1);
        ((IAdvancedSearchParamsDisplayer)Mockito.verify((Object)this.searchParamsDisplayer, (VerificationMode)Mockito.atLeastOnce())).update(SearchConsoleViewTest.fixture.objectType1, null, SearchConsoleViewTest.fixture.environment, SearchConsoleViewTest.fixture.viewUiContext);
    }

    @Test
    public void testUiComponentsEnableProgressively() {
        Assert.assertTrue((String)"Search for list should be enabled", (boolean)this.consolePageObject.canSelectObject());
        Assert.assertFalse((String)"Search in tree should be disabled", (boolean)this.consolePageObject.canSelectDestination());
        Assert.assertFalse((String)"Keywords text should be disabled", (boolean)this.consolePageObject.canEnterSearchText());
        Assert.assertFalse((String)"Subdestinations should be disabled", (boolean)this.consolePageObject.canSelectSubdestination());
        Assert.assertFalse((String)"Search button should be disabled", (boolean)this.consolePageObject.canSearch());
        Assert.assertFalse((String)"Group by combo should be disabled", (boolean)this.consolePageObject.canSelectHierarchy());
        this.selectObject(SearchConsoleViewTest.fixture.objectType1);
        Assert.assertTrue((String)"Search in list should be enabled", (boolean)this.consolePageObject.canSelectDestination());
        Assert.assertFalse((String)"Keywords text should be disabled", (boolean)this.consolePageObject.canEnterSearchText());
        Assert.assertFalse((String)"Subdestinations should be disabled", (boolean)this.consolePageObject.canSelectSubdestination());
        Assert.assertFalse((String)"Search button should be disabled", (boolean)this.consolePageObject.canSearch());
        Assert.assertFalse((String)"Group by combo should be disabled", (boolean)this.consolePageObject.canSelectHierarchy());
        this.consolePageObject.selectFirstPossibleDestination();
        Assert.assertFalse((String)"Keywords text should be disabled", (boolean)this.consolePageObject.canEnterSearchText());
        Assert.assertTrue((String)"Subdestinations should be enabled", (boolean)this.consolePageObject.canSelectDestination());
        Assert.assertTrue((String)"Search button should be enabled", (boolean)this.consolePageObject.canSearch());
        Assert.assertFalse((String)"Group by combo should not be disabled", (boolean)this.consolePageObject.canSelectHierarchy());
        this.selectObject(SearchConsoleViewTest.fixture.objectType2);
        this.consolePageObject.selectFirstPossibleDestination();
        Assert.assertTrue((String)"Group by combo should be enabled", (boolean)this.consolePageObject.canSelectHierarchy());
        Assert.assertTrue((String)"Keywords text should be enabled", (boolean)this.consolePageObject.canEnterSearchText());
        this.selectObject(SearchConsoleViewTest.fixture.objectType1);
        this.consolePageObject.selectFirstPossibleDestination();
        Assert.assertFalse((String)"Group by combo should be disabled", (boolean)this.consolePageObject.canSelectHierarchy());
        Assert.assertFalse((String)"Keywords text should be disabled", (boolean)this.consolePageObject.canEnterSearchText());
    }

    @Test
    public void testGroupingHieararchyComboDisplaysFirstElementByDefault() {
        this.selectObject(SearchConsoleViewTest.fixture.objectType2);
        this.consolePageObject.selectFirstPossibleDestination();
        Assert.assertEquals((String)"Group by combo does not display the item expected", (String)SearchConsoleViewTest.fixture.groupingHierarchy1.getDisplayName(), (String)this.consolePageObject.getSelectedGroupingHierarchy());
    }

    @Test
    public void testSubdestinationsButtonEnablement() {
        this.selectObject(SearchConsoleViewTest.fixture.objectType1);
        this.consolePageObject.selectFirstPossibleDestination();
        Assert.assertTrue((String)"Subdestinations button should be enabled when subdestinations available", (boolean)this.consolePageObject.canSelectSubdestination());
        this.selectObject(SearchConsoleViewTest.fixture.objectType2);
        this.consolePageObject.selectFirstPossibleDestination();
        Assert.assertFalse((String)"Subdestinations button should not be enabled when subdestinations not available", (boolean)this.consolePageObject.canSelectSubdestination());
    }

    private void selectObject(IObjectTypeDescription object) {
        this.consolePageObject.selectObject(object.getDisplayName());
    }

    @Test
    public void testChangingObjectTypesDisablesKeywordAndSubdestinationsSection() {
        this.selectObject(SearchConsoleViewTest.fixture.objectType2);
        this.consolePageObject.selectFirstPossibleDestination();
        Assert.assertTrue((String)"Keywords text should be enabled", (boolean)this.consolePageObject.canEnterSearchText());
        Assert.assertFalse((String)"Subdestinations should be disabled", (boolean)this.consolePageObject.canSelectSubdestination());
        this.selectObject(SearchConsoleViewTest.fixture.objectType1);
        this.consolePageObject.selectFirstPossibleDestination();
        Assert.assertFalse((String)"Keywords text should be disabled after object type change", (boolean)this.consolePageObject.canEnterSearchText());
        Assert.assertTrue((String)"Subdestinations should be enabled", (boolean)this.consolePageObject.canSelectSubdestination());
    }

    @Test
    public void testKeywordsEnablementChangesWhenActiveProvidersChange() {
        Assert.assertEquals((String)MessageFormat.format("The keyword text should be set to \"{0}\" when disabled", DiscoveryUIMessages.SearchConsoleView_NoObjectTypeSelectedHint), (String)DiscoveryUIMessages.SearchConsoleView_NoObjectTypeSelectedHint, (String)this.consolePageObject.getKeyword());
        Assert.assertFalse((String)"Keywords text should not be enabled", (boolean)this.consolePageObject.canEnterSearchText());
        this.selectObject(SearchConsoleViewTest.fixture.objectType3);
        Assert.assertEquals((String)MessageFormat.format("The keyword text should be set to \"{0}\"", DiscoveryUIMessages.SearchConsoleView_EnterKeywordHint), (String)DiscoveryUIMessages.SearchConsoleView_EnterKeywordHint, (String)this.consolePageObject.getKeyword());
        Assert.assertTrue((String)"Keywords text should not be enabled", (boolean)this.consolePageObject.canEnterSearchText());
        this.selectObject(SearchConsoleViewTest.fixture.objectType2);
        Assert.assertEquals((String)MessageFormat.format("The keyword text should be set to \"{0}\" when disabled", DiscoveryUIMessages.SearchConsoleView_NoDestinationSelectedHint), (String)DiscoveryUIMessages.SearchConsoleView_NoDestinationSelectedHint, (String)this.consolePageObject.getKeyword());
        Assert.assertFalse((String)"Keywords text should not be enabled", (boolean)this.consolePageObject.canEnterSearchText());
        this.consolePageObject.selectFirstPossibleDestination();
        Assert.assertTrue((String)"Keywords text should be enabled", (boolean)this.consolePageObject.canEnterSearchText());
        this.consolePageObject.enterKeyword("HELLO!");
        this.selectObject(SearchConsoleViewTest.fixture.objectType1);
        this.consolePageObject.selectFirstPossibleDestination();
        Assert.assertFalse((String)"Keywords text should not be enabled", (boolean)this.consolePageObject.canEnterSearchText());
        Assert.assertEquals((String)MessageFormat.format("The keyword text should be set to \"{0}\" when disabled", DiscoveryUIMessages.SearchConsoleView_UnsupportedTextSearch), (String)DiscoveryUIMessages.SearchConsoleView_UnsupportedTextSearch, (String)this.consolePageObject.getKeyword());
    }

    @Test
    public void testSearch() {
        this.selectObject(SearchConsoleViewTest.fixture.objectType2);
        this.consolePageObject.selectDestination(SearchConsoleViewTest.fixture.category2.getDisplayName(), SearchConsoleViewTest.fixture.destination4.getDisplayName());
        this.consolePageObject.enterKeyword(KEYWORD_SEARCH_PARAMETER);
        this.consolePageObject.search();
        this.consolePageObject.verifySearchPerformed(SearchConsoleViewTest.fixture.objectType2.getId(), SearchConsoleViewTest.fixture.destination4.getDisplayName(), KEYWORD_SEARCH_PARAMETER);
        ((IAdvancedSearchParamsDisplayer)Mockito.verify((Object)this.searchParamsDisplayer)).setParams((ISearchParameters)Mockito.any(ISearchParameters.class));
    }

    @Test
    public void testChangingDestinationsUpdatesAdvancedSearchParams() {
        Mockito.stub((Object)this.searchParamsDisplayer.isEnabled()).toReturn((Object)true);
        this.selectObject(SearchConsoleViewTest.fixture.objectType1);
        this.consolePageObject.selectFirstPossibleDestination();
        ((IAdvancedSearchParamsDisplayer)Mockito.verify((Object)this.searchParamsDisplayer)).update(SearchConsoleViewTest.fixture.objectType1, SearchConsoleViewTest.fixture.destination1, SearchConsoleViewTest.fixture.environment, SearchConsoleViewTest.fixture.viewUiContext);
    }

    @Test
    public void testShowResultInSession() {
        ISearchSession session = (ISearchSession)Mockito.mock(ISearchSession.class);
        Mockito.stub((Object)session.getId()).toReturn((Object)testSessionId);
        String searchProviderId = SearchConsoleViewTest.fixture.supportingTextSearchProviderDescription.getId();
        ISearchContext searchContext = (ISearchContext)Mockito.mock(ISearchContext.class);
        Mockito.stub((Object)searchContext.searchProviderId()).toReturn((Object)searchProviderId);
        Mockito.stub((Object)searchContext.session()).toReturn((Object)session);
        this.consolePageObject.showResult(searchContext);
        ((ITabbedSessionDisplayer)Mockito.verify(this.sessionDisplayer)).display((ISession)session);
    }

    @Test
    public void testViewRegistersProperSelectionProvider() {
        ((IWorkbenchPartSite)Mockito.verify((Object)this.consolePageObject.getViewSiteMock())).setSelectionProvider((ISelectionProvider)Mockito.any(SearchConsoleSelectionProvider.class));
    }

    @Test
    public void testManageDestinations() {
        this.consolePageObject.verifyManageDestinationsWorksCorrectly();
    }

    @Test
    public void testObjectTypeWithNoDestinations() {
        this.selectObject(SearchConsoleViewTest.fixture.objectTypeNoDestinations);
        Assert.assertTrue((String)"keyword text should be enabled", (boolean)this.consolePageObject.canEnterSearchText());
        Assert.assertFalse((String)"Search should be disabled because there is no search criteria", (boolean)this.consolePageObject.canSearch());
        this.consolePageObject.enterKeyword("asd");
        Assert.assertTrue((String)"Search should be enabled because search criteria was provided", (boolean)this.consolePageObject.canSearch());
    }

    @Test
    public void testRegisteringIllegalViewCustomization() {
        IGenericViewCustomization illegalCustomization = (IGenericViewCustomization)Mockito.mock(IGenericViewCustomization.class);
        try {
            this.consolePageObject.registerViewCustomization(illegalCustomization);
            Assert.fail((String)"IllegalArgumentException for illegal customization");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }
}

