/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.platform.discovery.ui.test.comp.internal.fixture;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.platform.discovery.core.internal.ISearchSession;
import org.eclipse.platform.discovery.runtime.api.GroupingHierarchy;
import org.eclipse.platform.discovery.runtime.api.IDestinationsProvider;
import org.eclipse.platform.discovery.runtime.api.ISearchDestination;
import org.eclipse.platform.discovery.runtime.api.ISearchProvider;
import org.eclipse.platform.discovery.runtime.api.ISearchSubdestination;
import org.eclipse.platform.discovery.runtime.internal.DestinationCategoryNotFoundException;
import org.eclipse.platform.discovery.runtime.internal.ISearchProviderConfiguration;
import org.eclipse.platform.discovery.runtime.internal.ProviderNotFoundException;
import org.eclipse.platform.discovery.runtime.internal.model.descriptions.IDestinationCategoryDescription;
import org.eclipse.platform.discovery.runtime.internal.model.descriptions.IDestinationsProviderDescription;
import org.eclipse.platform.discovery.runtime.internal.model.descriptions.IObjectTypeDescription;
import org.eclipse.platform.discovery.runtime.internal.model.descriptions.ISearchProviderDescription;
import org.eclipse.platform.discovery.testutils.utils.model.DestProviderDescriptionBuilder;
import org.eclipse.platform.discovery.testutils.utils.model.DestinationCategoryDescriptionBuilder;
import org.eclipse.platform.discovery.testutils.utils.model.DestinationsProviderBuilder;
import org.eclipse.platform.discovery.testutils.utils.model.ObjectTypeDescriptionBuilder;
import org.eclipse.platform.discovery.testutils.utils.model.SearchDestinationBuilder;
import org.eclipse.platform.discovery.testutils.utils.model.SearchProviderBuilder;
import org.eclipse.platform.discovery.testutils.utils.model.SearchProviderDescriptionBuilder;
import org.eclipse.platform.discovery.testutils.utils.model.SubdestinationBuilder;
import org.eclipse.platform.discovery.ui.api.IViewUiContext;
import org.eclipse.platform.discovery.util.api.env.IDiscoveryEnvironment;
import org.eclipse.platform.discovery.util.api.env.IErrorHandler;
import org.eclipse.platform.discovery.util.api.longop.ILongOperationRunner;
import org.eclipse.platform.discovery.util.internal.session.ISessionManager;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

public class SearchConsoleTestFixture {
    public static final String TEST_SEARCH_DEST_PROVIDER_PREFERENCE_PAGE_ID = "org.eclipse.platform.discovery.ui.test.comp.page1";
    public static final int VIEWERS_OFFSET = 60;
    private final String OBJECT_TYPE_ID1 = "org.eclipse.platform.discovery.objecttype1";
    private final String OBJECT_TYPE_ID2 = "org.eclipse.platform.discovery.objecttype2";
    private final String OBJECT_TYPE_ID3 = "org.eclipse.platform.discovery.objecttype3";
    private final String OBJECT_TYPE_NO_DESTINATIONS_ID = "org.eclipse.platform.discovery.nodestinations_objecttype";
    private final String OBJECT_TYPE_NAME_1 = "First object type";
    private final String OBJECT_TYPE_NAME_2 = "Second object type";
    private final String OBJECT_TYPE_NAME_3 = "Third object type";
    private final String OBJECT_TYPE_NO_DESTINATIONS_NAME = "Destination-less object type";
    public IObjectTypeDescription objectType1;
    public IObjectTypeDescription objectType2;
    public IObjectTypeDescription objectType3;
    public IObjectTypeDescription objectTypeNoDestinations;
    public IDestinationsProviderDescription destProviderDescr_cat1;
    public IDestinationsProviderDescription destProviderDescr_cat2;
    public IDestinationsProviderDescription destProviderDescr_cat3;
    public IDestinationsProvider destProvider_cat1;
    public IDestinationsProvider destProvider_cat2;
    public IDestinationsProvider destProvider_cat3;
    private final String DESTINATION_NAME1 = "First destination";
    private final String DESTINATION_NAME2 = "Second destination";
    private final String DESTINATION_NAME3 = "Third destination";
    private final String DESTINATION_NAME4 = "Fourth destination";
    private final String DESTINATION_NAME5 = "Fifth destination";
    public ISearchDestination destination1;
    public ISearchDestination destination2;
    public ISearchDestination destination3;
    public ISearchDestination destination4;
    public ISearchDestination destination5;
    private static final String CATEGORY_ID_1 = "category1";
    private static final String CATEGORY_ID_2 = "category2";
    private static final String CATEGORY_ID_3 = "category3";
    private static final String CATEGORY_NAME_1 = "First category";
    private static final String CATEGORY_NAME_2 = "Second category";
    private static final String CATEGORY_NAME_3 = "Third category";
    public IDestinationCategoryDescription category1;
    public IDestinationCategoryDescription category2;
    public IDestinationCategoryDescription category3;
    private static final String SUBDESTINATION_NAME_1 = "Subdestination 1";
    private static final String SUBDESTINATION_NAME_2 = "Subdestination 2";
    public ISearchSubdestination subdestination1;
    public ISearchSubdestination subdestination2;
    public Map<ISearchSubdestination, Boolean> subdestinationsActivityMap;
    private static final String SUPPORTING_TEXT_SEARCH_SEARCH_PROVIDER_ID = "SUPPORTING_TEXT_SEARCH_SEARCH_PROVIDER_ID";
    private static final String UNSUPPORTING_TEXT_SEARCH_SEARCH_PROVIDER_ID = "UNSUPPORTING_TEXT_SEARCH_SEARCH_PROVIDER_ID";
    private static final String SEARCH_PROVIDER_NO_DESTINATIONS_ID = "SEARCH_PROVIDER_NO_DESTINATIONS_ID";
    public ISearchProviderDescription supportingTextSearchProviderDescription;
    public ISearchProviderDescription unsupportingTextSearchProviderDescription;
    public ISearchProviderDescription searchProviderForObjTypeWithNoDestinations_Description;
    public ISearchProvider supportingTextSearchProviderInstance;
    public ISearchProvider unsupportingTextSearchProviderInstance;
    public ISearchProvider searchProviderForObjTypeWithNoDestinations_Instance;
    public ISearchProviderConfiguration searchProviderConfiguration;
    public GroupingHierarchy groupingHierarchy1;
    public GroupingHierarchy groupingHierarchy2;
    @Mock
    public IErrorHandler errorHandler;
    @Mock
    public ILongOperationRunner operationRunner;
    @Mock
    public IDiscoveryEnvironment environment;
    @Mock
    public ISessionManager<ISearchSession> sessionManager;
    @Mock
    public IViewUiContext viewUiContext;
    public NullProgressMonitor nullProgressMonitor;

    public SearchConsoleTestFixture() {
        MockitoAnnotations.initMocks((Object)this);
        this.nullProgressMonitor = new NullProgressMonitor();
        this.setupEnvironment();
        this.setupUiContext();
        this.setupObjectTypes();
        this.setupDestinations();
        this.setupDestinationProviders();
        this.setupDestinationCategories();
        this.setupSubdestinations();
        this.setupGroupingHierarchy();
        this.setupProviderInstances();
        this.setupProviderDescriptions();
        this.searchProviderConfiguration = this.createTestSearchProviderConfig();
    }

    private void setupUiContext() {
        Mockito.stub((Object)this.viewUiContext.getSecondColumnPosition()).toReturn((Object)60);
        Mockito.stub((Object)this.viewUiContext.controlsSpacing()).toReturn((Object)60);
    }

    private void setupEnvironment() {
        Mockito.stub((Object)this.environment.errorHandler()).toReturn((Object)this.errorHandler);
        Mockito.stub((Object)this.environment.operationRunner()).toReturn((Object)this.operationRunner);
        Mockito.stub((Object)this.environment.progressMonitor()).toReturn((Object)this.nullProgressMonitor);
    }

    private void setupObjectTypes() {
        this.objectType1 = this.stubObjectType("org.eclipse.platform.discovery.objecttype1", "First object type");
        this.objectType2 = this.stubObjectType("org.eclipse.platform.discovery.objecttype2", "Second object type");
        this.objectType3 = this.stubObjectType("org.eclipse.platform.discovery.objecttype3", "Third object type");
        this.objectTypeNoDestinations = this.stubObjectType("org.eclipse.platform.discovery.nodestinations_objecttype", "Destination-less object type");
    }

    private IObjectTypeDescription stubObjectType(String id, String displayName) {
        return (IObjectTypeDescription)new ObjectTypeDescriptionBuilder().withId(id).withName(displayName).object();
    }

    private void setupDestinations() {
        this.destination1 = this.stubDestination("First destination");
        this.destination2 = this.stubDestination("Second destination");
        this.destination3 = this.stubDestination("Third destination");
        this.destination4 = this.stubDestination("Fourth destination");
        this.destination5 = this.stubDestination("Fifth destination");
    }

    private ISearchDestination stubDestination(String displayName) {
        return (ISearchDestination)new SearchDestinationBuilder().withDisplayName(displayName).object();
    }

    private void setupSubdestinations() {
        this.subdestination1 = this.stubSubdestination(SUBDESTINATION_NAME_1);
        this.subdestination2 = this.stubSubdestination(SUBDESTINATION_NAME_2);
        this.subdestinationsActivityMap = new HashMap<ISearchSubdestination, Boolean>();
        this.subdestinationsActivityMap.put(this.subdestination1, false);
        this.subdestinationsActivityMap.put(this.subdestination2, false);
    }

    private ISearchSubdestination stubSubdestination(String displayName) {
        return (ISearchSubdestination)new SubdestinationBuilder().withName(displayName).object();
    }

    private ISearchProviderConfiguration createTestSearchProviderConfig() {
        return new ISearchProviderConfiguration(){

            public void activateSubdestination(IObjectTypeDescription searchObjectType, IDestinationCategoryDescription destinationCategory, ISearchProviderDescription searchProviderDescription, ISearchSubdestination subDestination, boolean activate) {
                SearchConsoleTestFixture.this.subdestinationsActivityMap.put(subDestination, new Boolean(activate));
            }

            public ISearchProviderDescription getActiveSearchProvider(IObjectTypeDescription objectType, IDestinationCategoryDescription destinationCategory) throws ProviderNotFoundException {
                if (destinationCategory == null) {
                    if (objectType.getId().equals(SearchConsoleTestFixture.this.objectTypeNoDestinations.getId())) {
                        return SearchConsoleTestFixture.this.searchProviderForObjTypeWithNoDestinations_Description;
                    }
                    throw new ProviderNotFoundException("Provider not found");
                }
                if (objectType.getId().equals(SearchConsoleTestFixture.this.objectType2.getId()) && destinationCategory.getId().equals(SearchConsoleTestFixture.CATEGORY_ID_2)) {
                    return SearchConsoleTestFixture.this.supportingTextSearchProviderDescription;
                }
                if (objectType.getId().equals(SearchConsoleTestFixture.this.objectType1.getId()) && destinationCategory.getId().equals(SearchConsoleTestFixture.CATEGORY_ID_1)) {
                    return SearchConsoleTestFixture.this.unsupportingTextSearchProviderDescription;
                }
                if (objectType.getId().equals(SearchConsoleTestFixture.this.objectType3.getId()) && destinationCategory.getId().equals(SearchConsoleTestFixture.CATEGORY_ID_3)) {
                    return SearchConsoleTestFixture.this.supportingTextSearchProviderDescription;
                }
                throw new ProviderNotFoundException("Provider not found");
            }

            public List<IDestinationCategoryDescription> getAvailableDestinationCategoriesForObjectType(IObjectTypeDescription objectType) {
                if (objectType.getId().equals(SearchConsoleTestFixture.this.objectType1.getId())) {
                    return Arrays.asList(SearchConsoleTestFixture.this.category1);
                }
                if (objectType.getId().equals(SearchConsoleTestFixture.this.objectType2.getId())) {
                    return Arrays.asList(SearchConsoleTestFixture.this.category2);
                }
                if (objectType.getId().equals(SearchConsoleTestFixture.this.objectType3.getId())) {
                    return Arrays.asList(SearchConsoleTestFixture.this.category3);
                }
                return Collections.emptyList();
            }

            public List<ISearchSubdestination> getAvailableSearchSubdestinations(IObjectTypeDescription objectType, IDestinationCategoryDescription destinationCategory, ISearchProviderDescription searchProvider) {
                if (objectType.getId().equals("org.eclipse.platform.discovery.objecttype1")) {
                    return Arrays.asList(SearchConsoleTestFixture.this.subdestination1, SearchConsoleTestFixture.this.subdestination2);
                }
                return new ArrayList<ISearchSubdestination>();
            }

            public List<IDestinationCategoryDescription> getDestinationCategories() {
                return Arrays.asList(SearchConsoleTestFixture.this.category1, SearchConsoleTestFixture.this.category2, SearchConsoleTestFixture.this.category3);
            }

            public List<IDestinationCategoryDescription> getDestinationCategoriesForDestination(ISearchDestination destination) throws DestinationCategoryNotFoundException {
                if (destination.equals((Object)SearchConsoleTestFixture.this.destination1)) {
                    return Arrays.asList(SearchConsoleTestFixture.this.category1);
                }
                if (destination.equals((Object)SearchConsoleTestFixture.this.destination5)) {
                    return Arrays.asList(SearchConsoleTestFixture.this.category3);
                }
                return Arrays.asList(SearchConsoleTestFixture.this.category2);
            }

            public boolean isSubdestinationActive(ISearchSubdestination subdestination, IObjectTypeDescription objectType, IDestinationCategoryDescription destCategory, ISearchProviderDescription searchProvider) {
                return SearchConsoleTestFixture.this.subdestinationsActivityMap.get(subdestination);
            }

            public List<ISearchProviderDescription> getAvailableSearchProviderDescriptions(IObjectTypeDescription searchObjectType) {
                throw new UnsupportedOperationException("Unexpected invocation");
            }

            public List<IObjectTypeDescription> getObjectTypes() {
                return Arrays.asList(SearchConsoleTestFixture.this.objectType1, SearchConsoleTestFixture.this.objectType2, SearchConsoleTestFixture.this.objectType3, SearchConsoleTestFixture.this.objectTypeNoDestinations);
            }

            public List<IDestinationsProviderDescription> getDestinationProvidersForCategory(IDestinationCategoryDescription category) {
                if (category.equals(SearchConsoleTestFixture.this.category1)) {
                    return Arrays.asList(SearchConsoleTestFixture.this.destProviderDescr_cat1);
                }
                if (category.equals(SearchConsoleTestFixture.this.category2)) {
                    return Arrays.asList(SearchConsoleTestFixture.this.destProviderDescr_cat2);
                }
                return Arrays.asList(SearchConsoleTestFixture.this.destProviderDescr_cat3);
            }

            public List<ISearchDestination> getSearchDestinations(IDestinationCategoryDescription category, IDestinationsProvider providerDescription) {
                return new ArrayList<ISearchDestination>(providerDescription.getSearchDestinations());
            }

            public List<IDestinationsProviderDescription> getAvailableDestinationProviders() {
                return Arrays.asList(SearchConsoleTestFixture.this.destProviderDescr_cat1, SearchConsoleTestFixture.this.destProviderDescr_cat2, SearchConsoleTestFixture.this.destProviderDescr_cat3);
            }
        };
    }

    private void setupGroupingHierarchy() {
        this.groupingHierarchy1 = new GroupingHierarchy("Grouping 1", (Object)"Grouping 1");
        this.groupingHierarchy2 = new GroupingHierarchy("Grouping 2", (Object)"Grouping 2");
    }

    private void setupProviderInstances() {
        this.supportingTextSearchProviderInstance = (ISearchProvider)new SearchProviderBuilder().withGroupingHierarchies(new GroupingHierarchy[]{this.groupingHierarchy1, this.groupingHierarchy2}).object();
        this.unsupportingTextSearchProviderInstance = (ISearchProvider)new SearchProviderBuilder().withGroupingHierarchies(new GroupingHierarchy[0]).object();
        this.searchProviderForObjTypeWithNoDestinations_Instance = (ISearchProvider)new SearchProviderBuilder().withGroupingHierarchies(new GroupingHierarchy[0]).object();
    }

    private void setupProviderDescriptions() {
        this.supportingTextSearchProviderDescription = this.stubSearchProviderDescription(true, SUPPORTING_TEXT_SEARCH_SEARCH_PROVIDER_ID, this.supportingTextSearchProviderInstance, this.category2, this.category3);
        this.unsupportingTextSearchProviderDescription = this.stubSearchProviderDescription(false, UNSUPPORTING_TEXT_SEARCH_SEARCH_PROVIDER_ID, this.unsupportingTextSearchProviderInstance, this.category1);
        this.searchProviderForObjTypeWithNoDestinations_Description = this.stubSearchProviderDescription(true, SEARCH_PROVIDER_NO_DESTINATIONS_ID, this.searchProviderForObjTypeWithNoDestinations_Instance, new IDestinationCategoryDescription[0]);
    }

    private ISearchProviderDescription stubSearchProviderDescription(boolean supportsTextSearch, String id, ISearchProvider searchProvInstance, IDestinationCategoryDescription ... destCategories) {
        return (ISearchProviderDescription)new SearchProviderDescriptionBuilder().supportsTextSearch(supportsTextSearch).withSearchProviderInstance(searchProvInstance).withDestinationCategories(destCategories).withId(id).object();
    }

    private void setupDestinationCategories() {
        this.category1 = this.stubDestinationCategoryDescription(CATEGORY_ID_1, CATEGORY_NAME_1, UNSUPPORTING_TEXT_SEARCH_SEARCH_PROVIDER_ID);
        this.category2 = this.stubDestinationCategoryDescription(CATEGORY_ID_2, CATEGORY_NAME_2, SUPPORTING_TEXT_SEARCH_SEARCH_PROVIDER_ID);
        this.category3 = this.stubDestinationCategoryDescription(CATEGORY_ID_3, CATEGORY_NAME_3, SUPPORTING_TEXT_SEARCH_SEARCH_PROVIDER_ID);
    }

    private IDestinationCategoryDescription stubDestinationCategoryDescription(String id, String displayName, String destProviderId) {
        return (IDestinationCategoryDescription)new DestinationCategoryDescriptionBuilder().withDestinationProviders(new String[]{destProviderId}).withId(id).withName(displayName).object();
    }

    private void setupDestinationProviders() {
        this.destProvider_cat1 = this.stubDestinationsProvider(this.destination1, this.destination2);
        this.destProvider_cat2 = this.stubDestinationsProvider(this.destination3, this.destination4);
        this.destProvider_cat3 = this.stubDestinationsProvider(this.destination5);
        this.destProviderDescr_cat1 = this.stubDestinationsProviderDescription(this.destProvider_cat1, TEST_SEARCH_DEST_PROVIDER_PREFERENCE_PAGE_ID);
        this.destProviderDescr_cat2 = this.stubDestinationsProviderDescription(this.destProvider_cat2, null);
        this.destProviderDescr_cat3 = this.stubDestinationsProviderDescription(this.destProvider_cat3, null);
    }

    private IDestinationsProvider stubDestinationsProvider(ISearchDestination ... destinations) {
        return (IDestinationsProvider)new DestinationsProviderBuilder().withDestinations(destinations).object();
    }

    private IDestinationsProviderDescription stubDestinationsProviderDescription(IDestinationsProvider destProviderInstance, String prefPageId) {
        return (IDestinationsProviderDescription)new DestProviderDescriptionBuilder().withProvider(destProviderInstance).withParefPageId(prefPageId).object();
    }
}

