/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.platform.discovery.ui.internal.view.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.platform.discovery.runtime.api.IDescriptiveObject;
import org.eclipse.platform.discovery.runtime.api.ISearchDestination;
import org.eclipse.platform.discovery.runtime.internal.model.descriptions.IDestinationCategoryDescription;

public abstract class DestinationsContentProvider
implements ITreeContentProvider {
    private final List<ISearchDestination> destinations = new ArrayList<ISearchDestination>();

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof ISearchDestination) {
            return new Object[0];
        }
        List<ISearchDestination> destinations = this.getSearchDestinationsForCategory((IDestinationCategoryDescription)parentElement);
        return this.sortSearchDestinations(destinations).toArray();
    }

    public Object getParent(Object element) {
        return null;
    }

    public boolean hasChildren(Object element) {
        return this.getChildren(element).length > 0;
    }

    public Object[] getElements(Object inputElement) {
        assert (inputElement instanceof List);
        List categories = (List)inputElement;
        return this.sortDestinationCategories(categories).toArray();
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.destinations.clear();
        if (newInput != null) {
            assert (newInput instanceof List);
            this.destinations.addAll((List)newInput);
        }
    }

    protected abstract List<ISearchDestination> getSearchDestinationsForCategory(IDestinationCategoryDescription var1);

    protected List<IDestinationCategoryDescription> sortDestinationCategories(List<IDestinationCategoryDescription> categories) {
        IDestinationCategoryDescription[] categoriesArr = categories.toArray(new IDestinationCategoryDescription[categories.size()]);
        Arrays.sort(categoriesArr, new Comparator<IDescriptiveObject>(){

            @Override
            public int compare(IDescriptiveObject o1, IDescriptiveObject o2) {
                return o1.getDisplayName().compareTo(o2.getDisplayName());
            }
        });
        return Arrays.asList(categoriesArr);
    }

    private List<ISearchDestination> sortSearchDestinations(List<ISearchDestination> destinations) {
        ISearchDestination[] destArr = destinations.toArray(new ISearchDestination[destinations.size()]);
        Arrays.sort(destArr, new Comparator<ISearchDestination>(){

            @Override
            public int compare(ISearchDestination o1, ISearchDestination o2) {
                return o1.getDisplayName().compareTo(o2.getDisplayName());
            }
        });
        return Arrays.asList(destArr);
    }
}

