/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.platform.discovery.util.internal.longop;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.IJobManager;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.platform.discovery.testutils.utils.jmock.Mock;
import org.eclipse.platform.discovery.util.api.longop.ILongOperation;
import org.eclipse.platform.discovery.util.api.longop.ILongOperationRunner;
import org.eclipse.platform.discovery.util.internal.longop.AbstractLongOpRunnerTests;
import org.eclipse.platform.discovery.util.internal.longop.ExceptionHelper;
import org.eclipse.platform.discovery.util.internal.longop.SchedulingRuleSynchRunner;
import org.jmock.core.Constraint;
import org.jmock.core.Invocation;
import org.jmock.core.Stub;

public class SchedulingRuleSynchRunnerTests
extends AbstractLongOpRunnerTests {
    private Mock<ISchedulingRule> ruleMock;
    private Mock<IJobManager> jmMock;
    private Mock<ILongOperationRunner> decoratedMock;

    @Override
    public void setUp() throws Exception {
        this.ruleMock = this.mock(ISchedulingRule.class);
        this.jmMock = this.mock(IJobManager.class);
        this.decoratedMock = this.mock(ILongOperationRunner.class);
        this.decoratedMock.expects(this.once()).method("run").with((Constraint)this.isA(ILongOperation.class)).will(new Stub(){

            public Object invoke(Invocation arg0) throws Throwable {
                try {
                    return ((ILongOperation)arg0.parameterValues.get(0)).run(SchedulingRuleSynchRunnerTests.this.monitor);
                }
                catch (Exception e) {
                    throw ExceptionHelper.rethrow((Exception)e);
                }
            }

            public StringBuffer describeTo(StringBuffer arg0) {
                arg0.append("call the passed long running operation");
                return arg0;
            }
        });
        super.setUp();
        this.jmMock.expects(this.once()).method("beginRule").with((Constraint)this.same(this.ruleMock.proxy()), (Constraint)this.same(this.monitor)).id("beginRule called");
        this.jmMock.expects(this.once()).method("endRule").with((Constraint)this.same(this.ruleMock.proxy())).after(this.jmMock, "beginRule called");
    }

    @Override
    protected ILongOperationRunner newRunner(IProgressMonitor monitor) {
        return new SchedulingRuleSynchRunner((ILongOperationRunner)this.decoratedMock.proxy(), (ISchedulingRule)this.ruleMock.proxy(), (IJobManager)this.jmMock.proxy());
    }
}

