/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.platform.discovery.util.xml;

import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.platform.discovery.testutils.utils.jmock.Mock;
import org.eclipse.platform.discovery.testutils.utils.jmock.MockObjectTestCase;
import org.eclipse.platform.discovery.util.api.longop.ILongOperation;
import org.eclipse.platform.discovery.util.api.longop.ILongOperationRunner;
import org.eclipse.platform.discovery.util.api.longop.LongOpCanceledException;
import org.eclipse.platform.discovery.util.api.xml.IXmlRepresentable;
import org.eclipse.platform.discovery.util.internal.xml.CollectionTransformer;
import org.jmock.core.Constraint;
import org.jmock.core.Invocation;
import org.jmock.core.Stub;

public class CollectionTransformerAdapterLoadingTest
extends MockObjectTestCase {
    private static final String XML_REPR = "This is a test XML representation";
    private CollectionTransformer transformer;
    private Mock<IAdapterManager> adapterManager;
    private Mock<IXmlRepresentable> xmlRepresentable;

    protected void setUp() throws Exception {
        this.xmlRepresentable = this.mock(IXmlRepresentable.class);
        this.xmlRepresentable.stubs().method("toStringXml").will(this.returnValue(XML_REPR));
        this.adapterManager = this.mock(IAdapterManager.class);
        this.transformer = new CollectionTransformer(){

            protected IAdapterManager getAdapterManager() {
                return (IAdapterManager)CollectionTransformerAdapterLoadingTest.this.adapterManager.proxy();
            }
        };
    }

    public void testFactoryIsOnlyLoadedOnce() {
        Object objectToAdapt = new Object();
        this.adapterManager.expects(this.once()).method("loadAdapter").with((Constraint)this.same(objectToAdapt), (Constraint)this.eq(IXmlRepresentable.class.getName())).will(this.returnValue(this.xmlRepresentable.proxy()));
        this.adapterManager.expects(this.exactly(2)).method("getAdapter").with((Constraint)this.same(objectToAdapt), (Constraint)this.eq(IXmlRepresentable.class)).will(new Stub(){
            private boolean alreadyInvoked = false;

            public Object invoke(Invocation arg0) throws Throwable {
                if (this.alreadyInvoked) {
                    return CollectionTransformerAdapterLoadingTest.this.xmlRepresentable.proxy();
                }
                this.alreadyInvoked = true;
                return null;
            }

            public StringBuffer describeTo(StringBuffer arg0) {
                return arg0;
            }
        });
        String transf1 = this.transformer.transform(Arrays.asList(objectToAdapt).iterator(), (ILongOperationRunner)new TestOpRunner());
        String transf2 = this.transformer.transform(Arrays.asList(objectToAdapt).iterator(), (ILongOperationRunner)new TestOpRunner());
        CollectionTransformerAdapterLoadingTest.assertEquals((String)"Transofrmations were not same", (String)transf1, (String)transf2);
        CollectionTransformerAdapterLoadingTest.assertTrue((String)"Transformation does not contain XML", (transf1.indexOf(XML_REPR) > -1 ? 1 : 0) != 0);
        CollectionTransformerAdapterLoadingTest.assertTrue((String)"Transformation does not contain XML", (transf2.indexOf(XML_REPR) > -1 ? 1 : 0) != 0);
    }

    private class TestOpRunner
    implements ILongOperationRunner {
        private TestOpRunner() {
        }

        public <T> T run(ILongOperation<T> op) throws LongOpCanceledException, InvocationTargetException {
            try {
                return (T)op.run((IProgressMonitor)new NullProgressMonitor());
            }
            catch (Exception e) {
                throw new InvocationTargetException(e);
            }
        }
    }
}

