/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.databinding.beans;

import java.beans.PropertyDescriptor;
import org.eclipse.core.databinding.beans.IBeanListProperty;
import org.eclipse.core.databinding.beans.IBeanMapProperty;
import org.eclipse.core.databinding.beans.IBeanSetProperty;
import org.eclipse.core.databinding.beans.IBeanValueProperty;
import org.eclipse.core.databinding.beans.PojoProperties;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.map.IObservableMap;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.property.value.IValueProperty;
import org.eclipse.core.databinding.property.value.ValueProperty;
import org.eclipse.core.internal.databinding.beans.BeanListPropertyDecorator;
import org.eclipse.core.internal.databinding.beans.BeanMapPropertyDecorator;
import org.eclipse.core.internal.databinding.beans.BeanObservableListDecorator;
import org.eclipse.core.internal.databinding.beans.BeanObservableMapDecorator;
import org.eclipse.core.internal.databinding.beans.BeanObservableValueDecorator;
import org.eclipse.core.internal.databinding.beans.BeanSetPropertyDecorator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PojoValuePropertyDecorator<S, T>
extends ValueProperty<S, T>
implements IBeanValueProperty<S, T> {
    private final IValueProperty<S, T> delegate;
    private final PropertyDescriptor propertyDescriptor;

    public PojoValuePropertyDecorator(IValueProperty<S, T> delegate, PropertyDescriptor propertyDescriptor) {
        this.delegate = delegate;
        this.propertyDescriptor = propertyDescriptor;
    }

    @Override
    public PropertyDescriptor getPropertyDescriptor() {
        return this.propertyDescriptor;
    }

    public Object getValueType() {
        return this.delegate.getValueType();
    }

    public Class<T> getValueClass() {
        return this.delegate.getValueClass();
    }

    protected T doGetValue(S source) {
        return (T)this.delegate.getValue(source);
    }

    protected void doSetValue(S source, T value) {
        this.delegate.setValue(source, value);
    }

    @Override
    public <V> IBeanValueProperty<S, V> value(String propertyName) {
        return this.value(propertyName, null);
    }

    @Override
    public <V> IBeanValueProperty<S, V> value(String propertyName, Class<V> valueType) {
        Class beanClass = this.delegate.getValueClass();
        return this.value(PojoProperties.value(beanClass, propertyName, valueType));
    }

    @Override
    public <V> IBeanValueProperty<S, V> value(IBeanValueProperty<T, V> property) {
        return new PojoValuePropertyDecorator<S, T>(super.value(property), property.getPropertyDescriptor());
    }

    @Override
    public <E> IBeanListProperty<S, E> list(String propertyName) {
        return this.list(propertyName, null);
    }

    @Override
    public <E> IBeanListProperty<S, E> list(String propertyName, Class<E> elementType) {
        Class beanClass = this.delegate.getValueClass();
        return this.list(PojoProperties.list(beanClass, propertyName, elementType));
    }

    @Override
    public <E> IBeanListProperty<S, E> list(IBeanListProperty<T, E> property) {
        return new BeanListPropertyDecorator(super.list(property), property.getPropertyDescriptor());
    }

    @Override
    public <E> IBeanSetProperty<S, E> set(String propertyName) {
        return this.set(propertyName, null);
    }

    @Override
    public <E> IBeanSetProperty<S, E> set(String propertyName, Class<E> elementType) {
        Class beanClass = this.delegate.getValueClass();
        return this.set(PojoProperties.set(beanClass, propertyName, elementType));
    }

    @Override
    public <E> IBeanSetProperty<S, E> set(IBeanSetProperty<T, E> property) {
        return new BeanSetPropertyDecorator(super.set(property), property.getPropertyDescriptor());
    }

    @Override
    public <K, V> IBeanMapProperty<S, K, V> map(String propertyName) {
        return this.map(propertyName, null, null);
    }

    @Override
    public <K, V> IBeanMapProperty<S, K, V> map(String propertyName, Class<K> keyType, Class<V> valueType) {
        Class beanClass = this.delegate.getValueClass();
        return this.map(PojoProperties.map(beanClass, propertyName, keyType, valueType));
    }

    @Override
    public <K, V> IBeanMapProperty<S, K, V> map(IBeanMapProperty<? super T, K, V> property) {
        return new BeanMapPropertyDecorator(super.map(property), property.getPropertyDescriptor());
    }

    public IObservableValue<T> observe(S source) {
        return new BeanObservableValueDecorator(this.delegate.observe(source), this.propertyDescriptor);
    }

    public IObservableValue<T> observe(Realm realm, S source) {
        return new BeanObservableValueDecorator(this.delegate.observe(realm, source), this.propertyDescriptor);
    }

    public <M extends S> IObservableValue<T> observeDetail(IObservableValue<M> master) {
        return new BeanObservableValueDecorator(this.delegate.observeDetail(master), this.propertyDescriptor);
    }

    public <M extends S> IObservableList<T> observeDetail(IObservableList<M> master) {
        return new BeanObservableListDecorator(this.delegate.observeDetail(master), this.propertyDescriptor);
    }

    public <M extends S> IObservableMap<M, T> observeDetail(IObservableSet<M> master) {
        return new BeanObservableMapDecorator(this.delegate.observeDetail(master), this.propertyDescriptor);
    }

    public <K, M extends S> IObservableMap<K, T> observeDetail(IObservableMap<K, M> master) {
        return new BeanObservableMapDecorator(this.delegate.observeDetail(master), this.propertyDescriptor);
    }

    public String toString() {
        return this.delegate.toString();
    }
}

