/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.databinding.observable.set;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.set.ObservableSet;
import org.eclipse.core.databinding.observable.set.SetChangeEvent;
import org.eclipse.core.databinding.observable.set.SetListenerManager;
import org.eclipse.core.internal.databinding.observable.IStalenessConsumer;
import org.eclipse.core.internal.databinding.observable.StalenessTracker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class UnionSet<E>
extends ObservableSet<E> {
    private Set<MyListenerManager<?>> childSets;
    private boolean stale = false;
    private HashMap<E, Integer> refCounts = null;
    private StalenessTracker stalenessTracker;
    private IStalenessConsumer stalenessConsumer = new IStalenessConsumer(){

        public void setStale(boolean stale) {
            boolean oldStale = UnionSet.this.stale;
            UnionSet.this.stale = stale;
            if (stale && !oldStale) {
                UnionSet.this.fireStale();
            }
        }
    };

    public UnionSet(IObservableSet<? extends E>[] childSets) {
        this(new HashSet<IObservableSet<? extends E>>(Arrays.asList(childSets)));
    }

    public UnionSet(Set<IObservableSet<? extends E>> childSets) {
        this((Set<IObservableSet<? extends E>>)childSets, childSets.iterator().next().getElementType());
    }

    public UnionSet(IObservableSet<? extends E>[] childSets, Object elementType) {
        this((Set<IObservableSet<? extends E>>)new HashSet<IObservableSet<? extends E>>(Arrays.asList(childSets)), elementType);
    }

    public UnionSet(Set<IObservableSet<? extends E>> childSets, Object elementType) {
        super(childSets.iterator().next().getRealm(), null, elementType);
        this.childSets = new HashSet();
        for (IObservableSet<E> iObservableSet : childSets) {
            this.addChildSet(iObservableSet);
        }
        this.stalenessTracker = new StalenessTracker(childSets.toArray(new IObservableSet[0]), this.stalenessConsumer);
    }

    private <E2 extends E> void addChildSet(IObservableSet<E2> childSet) {
        this.childSets.add(new MyListenerManager<E2>(childSet));
    }

    @Override
    public boolean isStale() {
        this.getterCalled();
        if (this.refCounts != null) {
            return this.stale;
        }
        for (MyListenerManager<?> childSet : this.childSets) {
            if (!childSet.decoratedSet.isStale()) continue;
            return true;
        }
        return false;
    }

    private void processAddsAndRemoves(Set<? extends E> adds, Set<? extends E> removes) {
        int refs;
        Integer refCount;
        HashSet<E> addsToFire = new HashSet<E>();
        HashSet<E> removesToFire = new HashSet<E>();
        for (E added : adds) {
            refCount = this.refCounts.get(added);
            if (refCount == null) {
                this.refCounts.put(added, new Integer(1));
                addsToFire.add(added);
                continue;
            }
            refs = refCount;
            refCount = new Integer(refs + 1);
            this.refCounts.put(added, refCount);
        }
        for (E removed : removes) {
            refCount = this.refCounts.get(removed);
            if (refCount == null) continue;
            refs = refCount;
            if (refs <= 1) {
                removesToFire.add(removed);
                this.refCounts.remove(removed);
                continue;
            }
            refCount = new Integer(refCount - 1);
            this.refCounts.put(removed, refCount);
        }
        addsToFire.removeAll(removesToFire);
        if (addsToFire.size() > 0 || removesToFire.size() > 0) {
            this.fireSetChange(Diffs.createSetDiff(addsToFire, removesToFire));
        }
    }

    @Override
    protected void firstListenerAdded() {
        super.firstListenerAdded();
        this.refCounts = new HashMap();
        for (MyListenerManager<?> childSet : this.childSets) {
            childSet.addListener();
            this.incrementRefCounts(childSet.decoratedSet);
        }
        this.stalenessTracker = new StalenessTracker(this.childSets.toArray(new IObservable[0]), this.stalenessConsumer);
        this.setWrappedSet(this.refCounts.keySet());
    }

    @Override
    protected void lastListenerRemoved() {
        super.lastListenerRemoved();
        for (MyListenerManager<?> childSet : this.childSets) {
            childSet.removeListener();
            this.stalenessTracker.removeObservable(childSet.decoratedSet);
        }
        this.refCounts = null;
        this.stalenessTracker = null;
        this.setWrappedSet(null);
    }

    private ArrayList<E> incrementRefCounts(Collection<? extends E> addedElements) {
        ArrayList<E> adds = new ArrayList<E>();
        for (E addedElement : addedElements) {
            Integer refCount = this.refCounts.get(addedElement);
            if (refCount == null) {
                adds.add(addedElement);
                refCount = new Integer(1);
                this.refCounts.put(addedElement, refCount);
                continue;
            }
            refCount = new Integer(refCount + 1);
            this.refCounts.put(addedElement, refCount);
        }
        return adds;
    }

    @Override
    protected void getterCalled() {
        super.getterCalled();
        if (this.refCounts == null) {
            this.setWrappedSet(this.computeElements());
        }
    }

    private Set<E> computeElements() {
        if (this.refCounts == null) {
            HashSet result = new HashSet();
            for (MyListenerManager<?> childSet : this.childSets) {
                result.addAll(childSet.decoratedSet);
            }
            return result;
        }
        return this.refCounts.keySet();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MyListenerManager<E2 extends E>
    extends SetListenerManager<E2> {
        public MyListenerManager(IObservableSet<E2> decoratedSet) {
            super(decoratedSet);
        }

        @Override
        public void handleSetChange(SetChangeEvent<E2> event) {
            UnionSet.this.processAddsAndRemoves(event.diff.getAdditions(), event.diff.getRemovals());
        }
    }
}

